/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.GCSCommon;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;

public class GCSFileUploader
extends GCSCommon {
    private static final Collection<String> WRITE_SCOPE = Collections.singleton("https://www.googleapis.com/auth/devstorage.read_write");

    public GCSFileUploader(File jsonKeyFile) {
        super(jsonKeyFile);
    }

    public GCSFileUploader() {
    }

    public void uploadFile(String bucketName, String gcsFilename, InputStream fileContents, String contentType, boolean allowOverwrite) throws IOException {
        InputStreamContent inputStreamData = new InputStreamContent(contentType, fileContents);
        StorageObject object = new StorageObject().setName(gcsFilename);
        if (!allowOverwrite && ((Objects)this.getWritableStorage().objects().list(bucketName).setPrefix(gcsFilename).execute()).getItems() != null) {
            throw new IOException("Can't write file.  Already exists and allowOverwrite is false.");
        }
        this.getWritableStorage().objects().insert(bucketName, object, inputStreamData).execute();
        LogUtil.CLog.d("Created file at: %s", gcsFilename);
    }

    private Storage getWritableStorage() throws IOException {
        return this.getStorage(WRITE_SCOPE);
    }
}

