/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.loganalysis.item.LogcatItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.parser.LogcatParser;
import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.MultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GenericLogcatEventParser<LogcatEventType>
implements Closeable {
    private static final String CUSTOM_CATEGORY = "parserEvent";
    private static final String LOGCAT_DESC = "LogcatEventParser-logcat";
    private static final String BASE_LOGCAT_CMD = "logcat -v threadtime -s";
    private final EventTriggerMap mEventTriggerMap = new EventTriggerMap();
    private final MultiLineReceiver mLogcatReceiver = new EventReceiver();
    private final LogcatParser mInternalParser = new LogcatParser();
    private final Set<String> mLogcatTags = new HashSet<String>();
    private final LinkedBlockingQueue<LogcatEvent> mEventQueue = new LinkedBlockingQueue();
    private BackgroundDeviceAction mDeviceAction;
    private ITestDevice mDevice;
    private boolean mCancelled = false;

    public GenericLogcatEventParser(ITestDevice device) {
        this.mDevice = device;
    }

    public void registerEventTrigger(String tag, String msg, LogcatEventType response) {
        this.mEventTriggerMap.put(tag, msg, response);
        if (this.mLogcatTags.add(tag)) {
            this.mInternalParser.addPattern(null, null, tag, CUSTOM_CATEGORY);
        }
    }

    public void registerEventTrigger(Log.LogLevel logLevel, String tag, String msg, LogcatEventType response) {
        this.mEventTriggerMap.put(tag, msg, response);
        if (this.mLogcatTags.add(tag)) {
            this.mInternalParser.addPattern(null, String.valueOf(logLevel.getPriorityLetter()), tag, CUSTOM_CATEGORY);
        }
    }

    public LogcatEvent waitForEvent(long timeoutMs) throws InterruptedException {
        return this.mEventQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public LogcatEvent pollForEvent() {
        return this.mEventQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void parseEvents(String[] lines) {
        LogcatItem items;
        if (lines.length == 0) {
            return;
        }
        LogUtil.CLog.v(String.join((CharSequence)"\n", lines));
        LogcatParser logcatParser = this.mInternalParser;
        synchronized (logcatParser) {
            items = this.mInternalParser.parse(Arrays.asList(lines));
            this.mInternalParser.clear();
        }
        if (items == null) {
            return;
        }
        for (MiscLogcatItem item : items.getEvents()) {
            Object eventType = this.mEventTriggerMap.get(item.getTag(), item.getStack());
            if (eventType == null) continue;
            this.mEventQueue.add(new LogcatEvent(eventType, item.getStack()));
        }
    }

    public void start() {
        this.mCancelled = false;
        if (this.mLogcatTags.isEmpty()) {
            throw new RuntimeException("LogcatEventParser started with no event triggers.");
        }
        StringBuilder logcatCmdBuilder = new StringBuilder(BASE_LOGCAT_CMD);
        for (String tag : this.mLogcatTags) {
            logcatCmdBuilder.append(" ").append(tag).append(":V");
        }
        String logcatCmd = logcatCmdBuilder.toString();
        LogUtil.CLog.i("Starting logcat with command: %s", logcatCmd);
        this.mDeviceAction = new BackgroundDeviceAction(logcatCmd, LOGCAT_DESC, this.mDevice, this.mLogcatReceiver, 0);
        this.mDeviceAction.start();
    }

    @Override
    public void close() {
        this.mCancelled = true;
        if (this.mDeviceAction != null) {
            this.mDeviceAction.cancel();
        }
    }

    private class EventTriggerMap {
        private MultiMap<String, AbstractMap.SimpleEntry<String, LogcatEventType>> mResponses = new MultiMap();

        private EventTriggerMap() {
        }

        private void put(String tag, String partialMessage, LogcatEventType response) {
            this.mResponses.put(tag, new AbstractMap.SimpleEntry(partialMessage, response));
        }

        private LogcatEventType get(String tag, String message2) {
            for (Map.Entry entry : this.mResponses.get(tag)) {
                if (!message2.contains((CharSequence)entry.getKey())) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    private class EventReceiver
    extends MultiLineReceiver {
        private EventReceiver() {
        }

        @Override
        public void processNewLines(String[] strings) {
            GenericLogcatEventParser.this.parseEvents(strings);
        }

        @Override
        public boolean isCancelled() {
            return GenericLogcatEventParser.this.mCancelled;
        }
    }

    public class LogcatEvent {
        private LogcatEventType eventType;
        private String msg;

        private LogcatEvent(LogcatEventType eventType, String msg) {
            this.eventType = eventType;
            this.msg = msg;
        }

        public LogcatEventType getEventType() {
            return this.eventType;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

