/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.log.LogUtil;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ExponentialBackOff;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GoogleApiClientUtil {
    public static final String APP_NAME = "tradefed";
    private static GoogleApiClientUtil sInstance = null;

    private static GoogleApiClientUtil getInstance() {
        if (sInstance == null) {
            sInstance = new GoogleApiClientUtil();
        }
        return sInstance;
    }

    public static Credential createCredentialFromJsonKeyFile(File file2, Collection<String> scopes) throws IOException, GeneralSecurityException {
        return GoogleApiClientUtil.getInstance().doCreateCredentialFromJsonKeyFile(file2, scopes);
    }

    @VisibleForTesting
    Credential doCreateCredentialFromJsonKeyFile(File file2, Collection<String> scopes) throws IOException, GeneralSecurityException {
        GoogleCredential credentail = GoogleCredential.fromStream(new FileInputStream(file2), GoogleNetHttpTransport.newTrustedTransport(), GsonFactory.getDefaultInstance()).createScoped(scopes);
        return credentail;
    }

    public static Credential createCredential(Collection<String> scopes, File primaryKeyFile, String hostOptionKeyFileName, File ... backupKeyFiles) throws IOException, GeneralSecurityException {
        return GoogleApiClientUtil.getInstance().doCreateCredential(scopes, primaryKeyFile, hostOptionKeyFileName, backupKeyFiles);
    }

    public static Credential createCredential(Collection<String> scopes, boolean useCredentialFactory, File primaryKeyFile, String hostOptionKeyFileName, File ... backupKeyFiles) throws IOException, GeneralSecurityException {
        Credential credential = null;
        if (useCredentialFactory) {
            credential = GoogleApiClientUtil.getInstance().doCreateCredentialFromCredentialFactory(scopes);
            if (credential != null) {
                return credential;
            }
            LogUtil.CLog.i("No CredentialFactory configured, fallback to key files.");
        }
        return GoogleApiClientUtil.getInstance().doCreateCredential(scopes, primaryKeyFile, hostOptionKeyFileName, backupKeyFiles);
    }

    @VisibleForTesting
    Credential doCreateCredential(Collection<String> scopes, File primaryKeyFile, String hostOptionKeyFileName, File ... backupKeyFiles) throws IOException, GeneralSecurityException {
        ArrayList<File> keyFiles = new ArrayList<File>();
        if (primaryKeyFile != null) {
            keyFiles.add(primaryKeyFile);
        }
        File hostOptionKeyFile = null;
        if (hostOptionKeyFileName != null) {
            try {
                hostOptionKeyFile = GlobalConfiguration.getInstance().getHostOptions().getServiceAccountJsonKeyFiles().get(hostOptionKeyFileName);
                if (hostOptionKeyFile != null) {
                    keyFiles.add(hostOptionKeyFile);
                }
            }
            catch (IllegalStateException e) {
                LogUtil.CLog.d("Global configuration haven't been initialized.");
            }
        }
        keyFiles.addAll(Arrays.asList(backupKeyFiles));
        for (File keyFile : keyFiles) {
            if (keyFile == null) continue;
            if (keyFile.exists() && keyFile.canRead()) {
                LogUtil.CLog.d("Using %s.", keyFile.getAbsolutePath());
                return this.doCreateCredentialFromJsonKeyFile(keyFile, scopes);
            }
            LogUtil.CLog.i("No access to %s.", keyFile.getAbsolutePath());
        }
        return this.doCreateDefaultCredential(scopes);
    }

    @VisibleForTesting
    Credential doCreateCredentialFromCredentialFactory(Collection<String> scopes) throws IOException {
        try {
            if (GlobalConfiguration.getInstance().getCredentialFactory() != null) {
                return GlobalConfiguration.getInstance().getCredentialFactory().createCredential(scopes);
            }
            LogUtil.CLog.w("No CredentialFactory configured.");
        }
        catch (IllegalStateException e) {
            System.out.println("GlobalConfiguration is not initialized yet,can not get CredentialFactory.");
        }
        return null;
    }

    @VisibleForTesting
    Credential doCreateDefaultCredential(Collection<String> scopes) throws IOException {
        try {
            LogUtil.CLog.d("Using local authentication.");
            return GoogleCredential.getApplicationDefault().createScoped(scopes);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Try 'gcloud auth application-default login' to login for personal account; Or 'export GOOGLE_APPLICATION_CREDENTIALS=/path/to/key.json' for service account.");
            throw e;
        }
    }

    @Deprecated
    public static Credential createCredentialFromP12File(String serviceAccount, File keyFile, Collection<String> scopes) throws GeneralSecurityException, IOException {
        return new GoogleCredential.Builder().setTransport(GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory(GsonFactory.getDefaultInstance()).setServiceAccountId(serviceAccount).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(keyFile).build();
    }

    public static HttpRequestInitializer setHttpTimeout(final HttpRequestInitializer requestInitializer, final int connectTimeout, final int readTimeout) {
        return new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) throws IOException {
                requestInitializer.initialize(request);
                request.setConnectTimeout(connectTimeout);
                request.setReadTimeout(readTimeout);
            }
        };
    }

    public static HttpRequestInitializer configureRetryStrategyAndTimeout(final HttpRequestInitializer initializer, final int connectTimeout, final int readTimeout) {
        return new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) throws IOException {
                initializer.initialize(request);
                request.setConnectTimeout(connectTimeout);
                request.setReadTimeout(readTimeout);
                request.setUnsuccessfulResponseHandler(new RetryResponseHandler());
            }
        };
    }

    public static HttpRequestInitializer configureRetryStrategy(final HttpRequestInitializer initializer) {
        return new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) throws IOException {
                initializer.initialize(request);
                request.setUnsuccessfulResponseHandler(new RetryResponseHandler());
            }
        };
    }

    private static class RetryResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private static final int INITIAL_RETRY_INTERVAL = 1000;
        private static final int MAX_RETRY_INTERVAL = 180000;
        private final HttpUnsuccessfulResponseHandler backOffHandler = new HttpBackOffUnsuccessfulResponseHandler(new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxIntervalMillis(180000).build());

        @Override
        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            LogUtil.CLog.w("Request to %s failed: %d %s", request.getUrl(), response.getStatusCode(), response.getStatusMessage());
            return this.backOffHandler.handleResponse(request, response, supportsRetry);
        }
    }
}

