/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HprofAllocSiteParser {
    private static final String ALLOC_SITES_START_PATTERN = "SITES BEGIN";
    private static final String ALLOC_SITES_END_PATTERN = "SITES END";
    private boolean mHasAllocSiteStarted = false;
    private static final Pattern RANK_PATTERN = Pattern.compile("(\\s+)([0-9]*)(\\s+)([0-9]*\\.?[0-9]+%)(\\s+)([0-9]*\\.?[0-9]+%)(\\s+)([0-9]+)(\\s+)([0-9]+)(\\s+)([0-9]+)(\\s+)([0-9]+)(\\s+)([0-9]+)(\\s+)(.*)");

    public Map<String, String> parse(File hprofReport) throws IOException {
        HashMap<String, String> results = new HashMap<String, String>();
        if (hprofReport == null || !hprofReport.exists()) {
            return results;
        }
        this.internalParse(hprofReport, results);
        return results;
    }

    private void internalParse(File report, Map<String, String> currentRes) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(report));){
            String line;
            while ((line = br.readLine()) != null) {
                this.handleAllocSites(line, currentRes);
            }
        }
    }

    private void handleAllocSites(String line, Map<String, String> currentRes) {
        Matcher m;
        if (line.startsWith(ALLOC_SITES_START_PATTERN)) {
            this.mHasAllocSiteStarted = true;
        } else if (line.startsWith(ALLOC_SITES_END_PATTERN)) {
            this.mHasAllocSiteStarted = false;
        } else if (this.mHasAllocSiteStarted && (m = RANK_PATTERN.matcher(line)).find()) {
            LogUtil.CLog.d("Rank %s-%s-%s-%s-%s-%s-%s-%s-%s", m.group(2), m.group(4), m.group(6), m.group(8), m.group(10), m.group(12), m.group(14), m.group(16), m.group(18));
            currentRes.put(String.format("Rank%s", m.group(2)), m.group(12));
        }
    }
}

