/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.xml.AbstractXmlParser;
import com.google.common.base.Strings;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JUnitXmlParser
extends AbstractXmlParser {
    private final String mRunName;
    private final ITestInvocationListener mTestListener;

    public JUnitXmlParser(ITestInvocationListener listener) {
        this.mRunName = null;
        this.mTestListener = listener;
    }

    public JUnitXmlParser(String runName, ITestInvocationListener listener) {
        this.mRunName = runName;
        this.mTestListener = listener;
    }

    @Override
    protected DefaultHandler createXmlHandler() {
        return new JUnitXmlHandler();
    }

    private class JUnitXmlHandler
    extends DefaultHandler {
        private static final String ERROR_TAG = "error";
        private static final String FAILURE_TAG = "failure";
        private static final String SKIPPED_TAG = "skipped";
        private static final String TESTSUITE_TAG = "testsuite";
        private static final String TESTCASE_TAG = "testcase";
        private TestDescription mCurrentTest = null;
        private StringBuffer mFailureContent = null;
        private String mCurrentMessage = null;
        private long mRunTimeMillis = 0L;

        private JUnitXmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.mFailureContent = null;
            this.mCurrentMessage = null;
            if (TESTSUITE_TAG.equalsIgnoreCase(name)) {
                String testSuiteName = this.getMandatoryAttribute(name, "name", attributes);
                String testCountString = this.getMandatoryAttribute(name, "tests", attributes);
                this.mRunTimeMillis = this.getTimeMillis(name, attributes);
                int testCount = Integer.parseInt(testCountString);
                String runName = JUnitXmlParser.this.mRunName != null ? JUnitXmlParser.this.mRunName : testSuiteName;
                JUnitXmlParser.this.mTestListener.testRunStarted(runName, testCount);
            }
            if (TESTCASE_TAG.equalsIgnoreCase(name)) {
                String testClassName = Strings.nullToEmpty(attributes.getValue("classname"));
                testClassName = "".equals(testClassName) ? JUnitXmlParser.class.getSimpleName() : testClassName;
                String methodName = this.getMandatoryAttribute(name, "name", attributes);
                this.mCurrentTest = new TestDescription(testClassName, methodName);
                JUnitXmlParser.this.mTestListener.testStarted(this.mCurrentTest);
            }
            if (SKIPPED_TAG.equalsIgnoreCase(name) && this.mCurrentTest != null) {
                JUnitXmlParser.this.mTestListener.testIgnored(this.mCurrentTest);
            }
            if (FAILURE_TAG.equalsIgnoreCase(name) || ERROR_TAG.equalsIgnoreCase(name)) {
                this.mFailureContent = new StringBuffer();
                String value = attributes.getValue("message");
                if (value != null) {
                    this.mCurrentMessage = value + ".";
                }
            }
        }

        @Override
        public void characters(char[] data, int offset, int len) {
            if (this.mFailureContent != null) {
                this.mFailureContent.append(data, offset, len);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (this.mFailureContent != null && this.mFailureContent.length() == 0 && this.mCurrentMessage != null) {
                this.mFailureContent.append(this.mCurrentMessage);
            }
            if (TESTSUITE_TAG.equalsIgnoreCase(name)) {
                JUnitXmlParser.this.mTestListener.testRunEnded(this.mRunTimeMillis, new HashMap<String, MetricMeasurement.Metric>());
            }
            if (TESTCASE_TAG.equalsIgnoreCase(name)) {
                JUnitXmlParser.this.mTestListener.testEnded(this.mCurrentTest, new HashMap<String, MetricMeasurement.Metric>());
            }
            if (FAILURE_TAG.equalsIgnoreCase(name) || ERROR_TAG.equalsIgnoreCase(name)) {
                FailureDescription failure = FailureDescription.create(this.mFailureContent.toString(), TestRecordProto.FailureStatus.TEST_FAILURE);
                JUnitXmlParser.this.mTestListener.testFailed(this.mCurrentTest, failure);
            }
            this.mFailureContent = null;
            this.mCurrentMessage = null;
        }

        String getMandatoryAttribute(String tagName, String attrName, Attributes attributes) throws SAXException {
            String value = attributes.getValue(attrName);
            if (value == null) {
                throw new SAXException(String.format("Malformed XML, could not find '%s' attribute in '%s'", attrName, tagName));
            }
            return value;
        }

        long getTimeMillis(String tagName, Attributes attributes) throws SAXException {
            Number n;
            String value = attributes.getValue("time");
            if (value == null) {
                return 0L;
            }
            NumberFormat f = NumberFormat.getInstance();
            try {
                n = f.parse(value);
            }
            catch (ParseException e) {
                throw new SAXException(String.format("%s.time value '%s' is not a number", tagName, value), e);
            }
            return (long)(n.floatValue() * 1000.0f);
        }
    }
}

