/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.ProcessInfo;
import com.android.tradefed.util.PsParser;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JavaCodeCoverageFlusher {
    private static final String COVERAGE_RESET_FORMAT = "am attach-agent %s /system/lib/libdumpcoverage.so=reset";
    private static final String COVERAGE_FLUSH_FORMAT = "am attach-agent %s /system/lib/libdumpcoverage.so=dump:%s";
    private static final String PACKAGE_PREFIX = "package:";
    private static final long FLUSH_DELAY = 60000L;
    private IRunUtil mRunUtil = RunUtil.getDefault();
    private final ITestDevice mDevice;
    private final List<String> mProcessNames;

    public JavaCodeCoverageFlusher(ITestDevice device, List<String> processNames) {
        this.mDevice = device;
        this.mProcessNames = ImmutableList.copyOf(processNames);
    }

    @VisibleForTesting
    void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
    }

    private List<String> getAllProcessNames() throws DeviceNotAvailableException {
        List<ProcessInfo> processes = PsParser.getProcesses(this.mDevice.executeShellCommand("ps -e"));
        ArrayList<String> names = new ArrayList<String>();
        for (ProcessInfo pinfo : processes) {
            names.add(pinfo.getName());
        }
        return names;
    }

    private Set<String> getAllPackages() throws DeviceNotAvailableException {
        Splitter splitter = Splitter.on('\n').trimResults().omitEmptyStrings();
        String pmListPackages = this.mDevice.executeShellCommand("pm list packages -a");
        List<String> lines = splitter.splitToList(pmListPackages);
        ImmutableSet.Builder packages = ImmutableSet.builder();
        for (String line : lines) {
            if (line.startsWith(PACKAGE_PREFIX)) {
                line = line.substring(PACKAGE_PREFIX.length());
            }
            packages.add(line);
        }
        return packages.build();
    }

    public void resetCoverage() throws DeviceNotAvailableException {
        List<String> processNames = this.mProcessNames;
        if (processNames.isEmpty()) {
            processNames = this.getAllProcessNames();
        }
        Set<String> javaPackages = this.getAllPackages();
        for (String processName : Sets.intersection(javaPackages, ImmutableSet.copyOf(processNames))) {
            String pid = this.mDevice.getProcessPid(processName);
            if (pid == null) continue;
            this.mDevice.executeShellCommand(String.format(COVERAGE_RESET_FORMAT, processName));
        }
        this.mDevice.executeShellCommand("cmd coverage reset");
    }

    public List<String> forceCoverageFlush() throws DeviceNotAvailableException {
        List<String> processNames = this.mProcessNames;
        if (processNames.isEmpty()) {
            processNames = this.getAllProcessNames();
        }
        ArrayList<String> coverageFiles = new ArrayList<String>();
        Set<String> javaPackages = this.getAllPackages();
        for (String processName : Sets.intersection(javaPackages, ImmutableSet.copyOf(processNames))) {
            String pid = this.mDevice.getProcessPid(processName);
            if (pid == null) continue;
            String outputPath = String.format("/data/misc/trace/%s-%s.ec", processName, pid);
            this.mDevice.executeShellCommand(String.format(COVERAGE_FLUSH_FORMAT, processName, outputPath));
            coverageFiles.add(outputPath);
        }
        this.mDevice.executeShellCommand("cmd coverage dump /data/misc/trace/system_server.ec");
        coverageFiles.add("/data/misc/trace/system_server.ec");
        this.mRunUtil.sleep(60000L);
        return coverageFiles;
    }
}

