/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeyguardControllerState {
    private static final Pattern NAME_PATTERN = Pattern.compile(".*KeyguardController:");
    private static final Pattern SHOWING_PATTERN = Pattern.compile("mKeyguardShowing=(\\S+)");
    private static final Pattern OCCLUDED_PATTERN = Pattern.compile("mOccluded=(\\S+)");
    private static final Pattern GOING_AWAY_PATTERN = Pattern.compile("mKeyguardGoingAway=(\\S+)");
    private boolean mKeyguardShowing;
    private boolean mKeyguardOccluded;
    private boolean mKeyguardGoingAway;

    private KeyguardControllerState() {
    }

    public static KeyguardControllerState create(List<String> dump) {
        String line = dump.get(0);
        Matcher matcher = NAME_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        KeyguardControllerState controller = new KeyguardControllerState();
        controller.extract(dump);
        return controller;
    }

    private void extract(List<String> dump) {
        for (String log : dump) {
            String line = log.trim();
            Matcher matcher = SHOWING_PATTERN.matcher(line);
            if (matcher.matches()) {
                String showingString = matcher.group(1);
                this.mKeyguardShowing = Boolean.valueOf(showingString);
                continue;
            }
            matcher = OCCLUDED_PATTERN.matcher(line);
            if (matcher.matches()) {
                String occludedString = matcher.group(1);
                this.mKeyguardOccluded = Boolean.valueOf(occludedString);
                continue;
            }
            matcher = GOING_AWAY_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            String goingAwayString = matcher.group(1);
            this.mKeyguardGoingAway = Boolean.valueOf(goingAwayString);
        }
    }

    public boolean isKeyguardShowing() {
        return this.mKeyguardShowing;
    }

    public boolean isKeyguardOccluded() {
        return this.mKeyguardOccluded;
    }

    public boolean isKeyguardGoingAway() {
        return this.mKeyguardGoingAway;
    }
}

