/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.log.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListInstrumentationParser
extends MultiLineReceiver {
    private static final Pattern LIST_INSTR_PATTERN = Pattern.compile("instrumentation:(.+)/(.+) \\(target=(.+)\\)");
    public static final Set<String> SHARDABLE_RUNNERS = new HashSet<String>(Arrays.asList("android.support.test.runner.AndroidJUnitRunner", "androidx.test.runner.AndroidJUnitRunner"));
    private List<InstrumentationTarget> mInstrumentationTargets = new ArrayList<InstrumentationTarget>();

    public List<InstrumentationTarget> getInstrumentationTargets() {
        Collections.sort(this.mInstrumentationTargets);
        return this.mInstrumentationTargets;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            LogUtil.CLog.d(line);
            Matcher m = LIST_INSTR_PATTERN.matcher(line);
            if (!m.find()) continue;
            this.mInstrumentationTargets.add(new InstrumentationTarget(m.group(1), m.group(2), m.group(3)));
        }
    }

    public static class InstrumentationTarget
    implements Comparable<InstrumentationTarget> {
        public final String packageName;
        public final String runnerName;
        public final String targetName;

        public InstrumentationTarget(String packageName, String runnerName, String targetName) {
            this.packageName = packageName;
            this.runnerName = runnerName;
            this.targetName = targetName;
        }

        public boolean equals(Object object) {
            if (object instanceof InstrumentationTarget) {
                InstrumentationTarget that = (InstrumentationTarget)object;
                return Objects.equals(this.packageName, that.packageName) && Objects.equals(this.runnerName, that.runnerName) && Objects.equals(this.targetName, that.targetName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.runnerName, this.targetName);
        }

        @Override
        public int compareTo(InstrumentationTarget o) {
            if (!this.packageName.equals(o.packageName)) {
                return this.packageName.compareTo(o.packageName);
            }
            if (!this.runnerName.equals(o.runnerName)) {
                return this.runnerName.compareTo(o.runnerName);
            }
            return this.targetName.compareTo(o.targetName);
        }

        public String toString() {
            return String.format("instrumentation:%s/%s (target=%s)", this.packageName, this.runnerName, this.targetName);
        }

        public boolean isShardable() {
            return SHARDABLE_RUNNERS.contains(this.runnerName);
        }
    }
}

