/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import java.util.List;

public class LocalRunInstructionBuilder {
    public static String getInstruction(ConfigurationDescriptor configDescriptor, ConfigurationDescriptor.LocalTestRunner runner) {
        return LocalRunInstructionBuilder.getInstruction(configDescriptor, runner, null);
    }

    public static String getInstruction(ConfigurationDescriptor configDescriptor, ConfigurationDescriptor.LocalTestRunner runner, TestDescription testId) {
        if (runner == null) {
            return null;
        }
        switch (runner) {
            case ATEST: {
                return LocalRunInstructionBuilder.getAtestInstruction(configDescriptor, testId);
            }
        }
        LogUtil.CLog.v("Runner %s is not supported yet, no instruction will be built.", new Object[]{runner});
        return null;
    }

    private static String getAtestInstruction(ConfigurationDescriptor configDescriptor, TestDescription testId) {
        StringBuilder instruction = new StringBuilder();
        instruction.append("Run following command to try the test in a local setup:\n");
        instruction.append(LocalRunInstructionBuilder.getCommand(configDescriptor, testId, ConfigurationDescriptor.LocalTestRunner.ATEST));
        return instruction.toString();
    }

    public static String getCommand(ConfigurationDescriptor configDescriptor, TestDescription testId, ConfigurationDescriptor.LocalTestRunner runner) {
        List<String> paramMetadata;
        if (runner != ConfigurationDescriptor.LocalTestRunner.ATEST) {
            return "";
        }
        StringBuilder instruction = new StringBuilder();
        StringBuilder testName = new StringBuilder(configDescriptor.getModuleName());
        boolean testMethodAdded = false;
        if (testId != null) {
            testName.append(String.format(":%s", testId.getClassName()));
            if (testId.getTestName().equals(testId.getTestNameWithoutParams())) {
                testName.append(String.format("#%s", testId.getTestName()));
                testMethodAdded = true;
            }
        }
        instruction.append(String.format("atest %s --", testName));
        if (configDescriptor.getAbi() != null) {
            instruction.append(String.format(" --abi %s", configDescriptor.getAbi().getName()));
        }
        if (!testMethodAdded) {
            for (OptionDef optionDef : configDescriptor.getRerunOptions()) {
                StringBuilder option = new StringBuilder(String.format("--module-arg %s:%s:", configDescriptor.getModuleName(), optionDef.name));
                if (optionDef.key == null) {
                    option.append(String.format("%s", optionDef.value));
                } else {
                    option.append(String.format("%s:=%s", optionDef.key, optionDef.value));
                }
                instruction.append(" " + option);
            }
        }
        if ((paramMetadata = configDescriptor.getMetaData("active-parameter")) != null && paramMetadata.size() > 0 && "instant".equals(paramMetadata.get(0))) {
            instruction.append(" --module-parameter " + (Object)((Object)ModuleParameters.INSTANT_APP));
        }
        return instruction.toString();
    }
}

