/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.math.Quantiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricUtility {
    private static final String TEST_HEADER_SEPARATOR = "\n\n";
    private static final String METRIC_SEPARATOR = "\n";
    private static final String METRIC_KEY_VALUE_SEPARATOR = ":";
    private static final String STATS_KEY_MIN = "min";
    private static final String STATS_KEY_MAX = "max";
    private static final String STATS_KEY_MEAN = "mean";
    private static final String STATS_KEY_VAR = "var";
    private static final String STATS_KEY_STDEV = "stdev";
    private static final String STATS_KEY_MEDIAN = "median";
    private static final String STATS_KEY_TOTAL = "total";
    private static final String STATS_KEY_COUNT = "metric-count";
    private static final String STATS_KEY_DIFF = "last-first-diff";
    private static final String STATS_KEY_PERCENTILE_PREFIX = "p";
    private static final String STATS_KEY_SEPARATOR = "-";
    private static final Joiner CLASS_METHOD_JOINER = Joiner.on("#").skipNulls();
    private String mTestIterationSeparator = "$";
    private Set<Integer> mActualPercentiles = new LinkedHashSet<Integer>();
    private Map<String, ArrayListMultimap<String, MetricMeasurement.Metric>> mStoredTestMetrics = new LinkedHashMap<String, ArrayListMultimap<String, MetricMeasurement.Metric>>();

    public void storeTestMetrics(TestDescription testDescription, Map<String, MetricMeasurement.Metric> testMetrics) {
        String newTestId;
        if (testMetrics == null) {
            return;
        }
        String className = testDescription.getClassName();
        int iterationSeparatorIndex = testDescription.getClassName().indexOf(this.mTestIterationSeparator);
        if (iterationSeparatorIndex != -1) {
            className = testDescription.getClassName().substring(0, iterationSeparatorIndex);
        }
        if (!this.mStoredTestMetrics.containsKey(newTestId = CLASS_METHOD_JOINER.join(className, testDescription.getTestName(), new Object[0]))) {
            this.mStoredTestMetrics.put(newTestId, ArrayListMultimap.create());
        }
        ArrayListMultimap<String, MetricMeasurement.Metric> storedMetricsForThisTest = this.mStoredTestMetrics.get(newTestId);
        for (Map.Entry<String, MetricMeasurement.Metric> entry : testMetrics.entrySet()) {
            storedMetricsForThisTest.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public File writeResultsToFile(String testFileSuffix, String testHeaderName, Map<String, String> metrics, File resultsFile) {
        if (resultsFile == null) {
            try {
                resultsFile = FileUtil.createTempFile(String.format("test_results_%s_", testFileSuffix), "");
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                return resultsFile;
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(resultsFile, true);){
            outputStream.write(String.format("%s%s", testHeaderName, TEST_HEADER_SEPARATOR).getBytes());
            for (Map.Entry<String, String> entry : metrics.entrySet()) {
                String test_metric = String.format("%s%s%s", entry.getKey(), METRIC_KEY_VALUE_SEPARATOR, entry.getValue());
                outputStream.write(String.format("%s%s", test_metric, METRIC_SEPARATOR).getBytes());
            }
            outputStream.write(TEST_HEADER_SEPARATOR.getBytes());
        }
        catch (IOException ioe) {
            LogUtil.CLog.e(ioe);
        }
        return resultsFile;
    }

    public Map<String, MetricMeasurement.Metric> aggregateMetrics(Map<String, MetricMeasurement.Metric> rawMetrics) {
        LinkedHashMap<String, MetricMeasurement.Metric> aggregateMetrics = new LinkedHashMap<String, MetricMeasurement.Metric>();
        for (Map.Entry<String, MetricMeasurement.Metric> entry : rawMetrics.entrySet()) {
            String values2 = entry.getValue().getMeasurements().getSingleString();
            List<String> splitVals = Arrays.asList(values2.split(",", 0));
            if (!MetricUtility.isAllDoubleValues(splitVals)) continue;
            this.buildStats(entry.getKey(), splitVals, aggregateMetrics);
        }
        return aggregateMetrics;
    }

    public File aggregateStoredTestMetricsAndWriteToFile(String fileName) {
        File resultsFile = null;
        for (String testName : this.mStoredTestMetrics.keySet()) {
            ArrayListMultimap<String, MetricMeasurement.Metric> currentTest = this.mStoredTestMetrics.get(testName);
            LinkedHashMap<String, MetricMeasurement.Metric> aggregateMetrics = new LinkedHashMap<String, MetricMeasurement.Metric>();
            for (String metricKey : currentTest.keySet()) {
                List metrics = currentTest.get((Object)metricKey);
                List measures = metrics.stream().map(MetricMeasurement.Metric::getMeasurements).collect(Collectors.toList());
                List<String> rawValues = measures.stream().map(MetricMeasurement.Measurements::getSingleString).map(m -> {
                    List<String> splitVals = Arrays.asList(m.split(",", 0));
                    if (splitVals.size() == 1 && splitVals.get(0).isEmpty()) {
                        return Collections.emptyList();
                    }
                    return splitVals;
                }).flatMap(Collection::stream).map(String::trim).collect(Collectors.toList());
                if (rawValues.isEmpty() || !MetricUtility.isAllDoubleValues(rawValues)) continue;
                this.buildStats(metricKey, rawValues, aggregateMetrics);
            }
            Map<String, String> compatibleTestMetrics = TfMetricProtoUtil.compatibleConvert(aggregateMetrics);
            resultsFile = this.writeResultsToFile(fileName, testName, compatibleTestMetrics, resultsFile);
        }
        return resultsFile;
    }

    public void setPercentiles(Set<Integer> percentiles) {
        this.mActualPercentiles = percentiles;
    }

    public void setIterationSeparator(String separator) {
        this.mTestIterationSeparator = separator;
    }

    public Map<String, ArrayListMultimap<String, MetricMeasurement.Metric>> getStoredTestMetric() {
        return this.mStoredTestMetrics;
    }

    public static boolean isAllDoubleValues(List<String> rawValues) {
        return rawValues.stream().allMatch(val -> {
            try {
                Double.parseDouble(val);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public static Map<String, Double> getStats(List<Double> values2, Set<Integer> percentiles) {
        LinkedHashMap<String, Double> stats = new LinkedHashMap<String, Double>();
        double sum = values2.stream().mapToDouble(Double::doubleValue).sum();
        double count = values2.size();
        double mean = values2.stream().mapToDouble(Double::doubleValue).average().orElseThrow(IllegalStateException::new);
        double variance = values2.stream().reduce(0.0, (a, b) -> a + Math.pow(b - mean, 2.0) / count);
        LinkedHashSet<Integer> updatedPercentile = new LinkedHashSet<Integer>(percentiles);
        updatedPercentile.add(50);
        Map<Integer, Double> percentileStat = Quantiles.percentiles().indexes(updatedPercentile).compute(values2);
        double median = percentileStat.get(50);
        double diff = values2.size() > 1 ? values2.get(values2.size() - 1) - values2.get(0) : values2.get(0);
        stats.put(STATS_KEY_MIN, Collections.min(values2));
        stats.put(STATS_KEY_MAX, Collections.max(values2));
        stats.put(STATS_KEY_MEAN, mean);
        stats.put(STATS_KEY_VAR, variance);
        stats.put(STATS_KEY_STDEV, Math.sqrt(variance));
        stats.put(STATS_KEY_MEDIAN, median);
        stats.put(STATS_KEY_TOTAL, sum);
        stats.put(STATS_KEY_COUNT, count);
        stats.put(STATS_KEY_DIFF, diff);
        percentileStat.entrySet().stream().forEach(e -> {
            if ((Integer)e.getKey() != 50 || percentiles.contains(50)) {
                stats.put(STATS_KEY_PERCENTILE_PREFIX + ((Integer)e.getKey()).toString(), (Double)e.getValue());
            }
        });
        return stats;
    }

    private void buildStats(String metricKey, List<String> values2, Map<String, MetricMeasurement.Metric> aggregateMetrics) {
        List<Double> doubleValues = values2.stream().map(Double::parseDouble).collect(Collectors.toList());
        Map<String, Double> stats = MetricUtility.getStats(doubleValues, this.mActualPercentiles);
        for (String statKey : stats.keySet()) {
            MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder();
            metricBuilder.getMeasurementsBuilder().setSingleString(String.format("%2.2f", stats.get(statKey)));
            aggregateMetrics.put(String.join((CharSequence)STATS_KEY_SEPARATOR, metricKey, statKey), metricBuilder.build());
        }
    }
}

