/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.IConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModuleTestTypeUtil {
    public static final String TEST_TYPE_KEY = "test-type";
    public static final String TEST_TYPE_VALUE_PERFORMANCE = "performance";

    public static boolean isPerformanceModule(IConfiguration config) {
        List<String> matched = ModuleTestTypeUtil.getMatchedConfigTestTypes(config, Arrays.asList(TEST_TYPE_VALUE_PERFORMANCE));
        return !matched.isEmpty();
    }

    public static List<String> getMatchedConfigTestTypes(IConfiguration config, List<String> testTypesToMatch) {
        ArrayList<String> matchedTypes = new ArrayList<String>();
        ConfigurationDescriptor cd = config.getConfigurationDescription();
        if (cd == null) {
            throw new RuntimeException(config + ": configuration descriptor is null");
        }
        List<String> testTypes = cd.getMetaData(TEST_TYPE_KEY);
        if (testTypes != null) {
            for (String testType : testTypes) {
                if (!testTypesToMatch.contains(testType)) continue;
                matchedTypes.add(testType);
            }
        }
        return matchedTypes;
    }
}

