/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, List<V>> mInternalMap = new LinkedHashMap<K, List<V>>();

    public MultiMap() {
    }

    public MultiMap(MultiMap<K, V> map) {
        this();
        for (K key : map.keySet()) {
            List<V> value = map.get(key);
            this.mInternalMap.put(key, value);
        }
    }

    public MultiMap(Map<K, V> map) {
        this();
        for (K key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void clear() {
        this.mInternalMap.clear();
    }

    public boolean containsKey(K key) {
        return this.mInternalMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (List<V> valueList : this.mInternalMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    public List<V> get(K key) {
        return this.mInternalMap.get(key);
    }

    public boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    public Set<K> keySet() {
        return this.mInternalMap.keySet();
    }

    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<AbstractMap.SimpleImmutableEntry<K, V>> entries = new ArrayList<AbstractMap.SimpleImmutableEntry<K, V>>();
        for (K key : this.keySet()) {
            for (V value : this.get(key)) {
                entries.add(new AbstractMap.SimpleImmutableEntry<K, V>(key, value));
            }
        }
        return Collections.unmodifiableList(entries);
    }

    public V put(K key, V value) {
        List<V> valueList = this.mInternalMap.get(key);
        if (valueList == null) {
            valueList = new LinkedList<V>();
            this.mInternalMap.put(key, valueList);
        }
        valueList.add(value);
        return value;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(MultiMap<K, ? extends V> m) {
        for (K key : m.keySet()) {
            for (V value : m.get(key)) {
                this.put(key, value);
            }
        }
    }

    public List<V> remove(K key) {
        return this.mInternalMap.remove(key);
    }

    public int size() {
        return this.mInternalMap.size();
    }

    public List<V> values() {
        LinkedList<V> allValues = new LinkedList<V>();
        for (List<V> valueList : this.mInternalMap.values()) {
            allValues.addAll(valueList);
        }
        return allValues;
    }

    public Map<String, V> getUniqueMap() {
        HashMap uniqueMap = new HashMap();
        for (Map.Entry<K, List<V>> entry : this.mInternalMap.entrySet()) {
            int count = 1;
            for (V value : entry.getValue()) {
                if (count == 1) {
                    this.addUniqueEntry(uniqueMap, entry.getKey().toString(), value);
                } else {
                    this.addUniqueEntry(uniqueMap, String.format("%s%d", entry.getKey(), count), value);
                }
                ++count;
            }
        }
        return uniqueMap;
    }

    private String addUniqueEntry(Map<String, V> uniqueMap, String proposedKey, V value) {
        if (uniqueMap.containsKey(proposedKey)) {
            return this.addUniqueEntry(uniqueMap, String.format("%s%s", proposedKey, "X"), value);
        }
        uniqueMap.put(proposedKey, value);
        return proposedKey;
    }

    public int hashCode() {
        return this.mInternalMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMap other = (MultiMap)obj;
        return Objects.equal(this.mInternalMap, other.mInternalMap);
    }
}

