/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.ProcessInfo;
import com.android.tradefed.util.PsParser;
import com.android.tradefed.util.RunUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;

public final class NativeCodeCoverageFlusher {
    private static final String EXTRACT_SIGCGT_FORMAT = "cat /proc/%d/status | grep SigCgt | awk '{ print $2 }'";
    private static final long SIGNAL_37_BIT = 0x1000000000L;
    private static final String COVERAGE_FLUSH_COMMAND_FORMAT = "kill -37 %s";
    private static final String CLEAR_CLANG_COVERAGE_FILES = "find /data/misc/trace -name '*.profraw' -delete";
    private static final String CLEAR_GCOV_COVERAGE_FILES = "find /data/misc/trace -name '*.gcda' -delete";
    private static final long FLUSH_DELAY_MS = 120000L;
    private final ITestDevice mDevice;
    private final List<String> mProcessNames;
    private IRunUtil mRunUtil = RunUtil.getDefault();

    public NativeCodeCoverageFlusher(ITestDevice device, List<String> processNames) {
        this.mDevice = device;
        this.mProcessNames = processNames;
    }

    public void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
    }

    public void resetCoverage() throws DeviceNotAvailableException {
        this.forceCoverageFlush();
        this.deleteCoverageMeasurements();
    }

    public void deleteCoverageMeasurements() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand(CLEAR_CLANG_COVERAGE_FILES);
        this.mDevice.executeShellCommand(CLEAR_GCOV_COVERAGE_FILES);
    }

    public void forceCoverageFlush() throws DeviceNotAvailableException {
        Preconditions.checkState(this.mDevice.isAdbRoot(), "adb root is required to flush native coverage data.");
        List<Integer> signalHandlingPids = this.findSignalHandlingPids(this.mProcessNames);
        StringJoiner pidString = new StringJoiner(" ");
        LogUtil.CLog.d("Signal handling pids: %s", signalHandlingPids.toString());
        for (Integer pid : signalHandlingPids) {
            pidString.add(pid.toString());
        }
        if (pidString.length() > 0) {
            this.mDevice.executeShellCommand(String.format(COVERAGE_FLUSH_COMMAND_FORMAT, pidString.toString()));
        }
        this.mRunUtil.sleep(120000L);
        this.mDevice.waitForDeviceAvailable();
    }

    private List<Integer> findSignalHandlingPids(List<String> processNames) throws DeviceNotAvailableException {
        List<ProcessInfo> allProcessInfo = PsParser.getProcesses(this.mDevice.executeShellCommand("ps -e"));
        ImmutableList.Builder signalHandlingPids = ImmutableList.builder();
        for (ProcessInfo processInfo : allProcessInfo) {
            CommandResult result = this.mDevice.executeShellV2Command(String.format(EXTRACT_SIGCGT_FORMAT, processInfo.getPid()));
            if (!result.getStatus().equals((Object)CommandStatus.SUCCESS) || result.getExitCode() != 0) {
                LogUtil.CLog.w("Failed to read /proc/%d/status for %s", processInfo.getPid(), processInfo.getName());
                continue;
            }
            if (result.getStdout().trim().isEmpty()) {
                LogUtil.CLog.w("Empty string when retrieving SigCgt for %s (pid %d)", processInfo.getName(), processInfo.getPid());
                continue;
            }
            long sigCgt = Long.parseUnsignedLong(result.getStdout().trim(), 16);
            if ((sigCgt & 0x1000000000L) != 0x1000000000L || !processNames.isEmpty() && !processNames.contains(processInfo.getName())) continue;
            signalHandlingPids.add((Object)processInfo.getPid());
        }
        return signalHandlingPids.build();
    }
}

