/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.loganalysis.util.config.Option;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PerfettoTraceRecorder {
    private static final String TRACE_NAME_FORMAT = "device-trace_%s_";
    @Option(name="perfetto-executable", description="Perfetto script file which will be used to record trace.")
    private File perfettoExecutable = null;
    @Option(name="output-path", description="Path where the files will be saved.")
    private String outputPath = System.getProperty("java.io.tmpdir");
    private Map<ITestDevice, DeviceTraceMetadata> deviceMetadataMap = new LinkedHashMap<ITestDevice, DeviceTraceMetadata>();
    private Set<String> deviceSerialsWithTrace = new HashSet<String>();
    private static final long SCRIPT_START_TIMEOUT = 10000L;

    public void startTrace(final ITestDevice device, Map<String, String> extraConfigs) throws IOException {
        if (this.deviceMetadataMap.containsKey(device)) {
            LogUtil.CLog.d("Already recording trace on %s in pid %s.", device.getSerialNumber(), this.deviceMetadataMap.get(device).getProcess().pid());
            return;
        }
        DeviceTraceMetadata deviceTraceMetadata = new DeviceTraceMetadata();
        if (this.perfettoExecutable == null) {
            this.perfettoExecutable = FileUtil.createTempFile("record_android_trace", ".txt");
            InputStream script = PerfettoTraceRecorder.class.getResourceAsStream("/perfetto/record_android_trace");
            FileUtil.writeToFile(script, this.perfettoExecutable);
        }
        deviceTraceMetadata.setPerfettoScript(this.perfettoExecutable, false);
        RunUtil.getDefault().runTimedCmd(10000L, "chmod", "u+x", this.perfettoExecutable.getAbsolutePath());
        File traceConfigFile = FileUtil.createTempFile("trace_config", ".textproto");
        InputStream configStream = PerfettoTraceRecorder.class.getResourceAsStream("/perfetto/trace_config.textproto");
        String configStr = StreamUtil.getStringFromStream(configStream);
        if (extraConfigs != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> configKeyValue : extraConfigs.entrySet()) {
                sb.append(String.format("%s: %s\n", configKeyValue.getKey(), configKeyValue.getValue()));
            }
            String injectedStr = sb.toString();
            configStr = configStr.replace("# {injected_config}", injectedStr);
        }
        FileUtil.writeToFile(configStr, traceConfigFile);
        deviceTraceMetadata.setTraceConfig(traceConfigFile, true);
        File traceOutput = FileUtil.createTempFile(String.format(TRACE_NAME_FORMAT, device.getSerialNumber()), ".perfetto-trace");
        deviceTraceMetadata.setTraceOutput(traceOutput, false);
        List<String> cmd = Arrays.asList(this.perfettoExecutable.getAbsolutePath(), "-c", traceConfigFile.getAbsolutePath(), "-s", device.getSerialNumber(), "-o", traceOutput.getAbsolutePath(), "-n");
        Process process = RunUtil.getDefault().runCmdInBackground(cmd, new OutputStream(){
            public String output = "";

            @Override
            public void write(int b) throws IOException {
                this.output = this.output + b;
                this.checkOutput();
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.output = this.output + new String(b, off, len);
                this.checkOutput();
            }

            private void checkOutput() {
                if (this.output.contains("beginning of main")) {
                    PerfettoTraceRecorder.this.deviceSerialsWithTrace.add(device.getSerialNumber());
                }
            }
        });
        try (CloseableTraceScope ignore = new CloseableTraceScope("perfetto-script-start-time");){
            long startTime = System.currentTimeMillis();
            while (!this.deviceSerialsWithTrace.contains(device.getSerialNumber()) && System.currentTimeMillis() - startTime < 10000L) {
                RunUtil.getDefault().sleep(1000L);
            }
        }
        if (!this.deviceSerialsWithTrace.contains(device.getSerialNumber())) {
            LogUtil.CLog.w("Perfetto script did not start on device %s within %sms. Trace file may miss some events.", device.getSerialNumber(), 10000L);
        }
        deviceTraceMetadata.setProcess(process);
        this.deviceMetadataMap.put(device, deviceTraceMetadata);
    }

    public File stopTrace(ITestDevice device) {
        if (this.deviceMetadataMap.containsKey(device)) {
            DeviceTraceMetadata metadata = this.deviceMetadataMap.remove(device);
            this.deviceSerialsWithTrace.remove(device.getSerialNumber());
            CommandResult result = RunUtil.getDefault().runTimedCmd(10000L, "kill", "-2", String.valueOf(metadata.getProcess().pid()));
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.d(result.getStderr());
                return null;
            }
            try {
                boolean terminated = metadata.getProcess().waitFor(10000L, TimeUnit.MILLISECONDS);
                if (!terminated) {
                    LogUtil.CLog.d("Perfetto process did not finish collection within 10 seconds. Trace file may be empty.");
                }
            }
            catch (InterruptedException e) {
                LogUtil.CLog.w(e);
            }
            metadata.cleanUp();
            return metadata.getTraceOutput();
        }
        return null;
    }

    private class DeviceTraceMetadata {
        public Process process;
        private File traceConfig;
        private File traceOutput;
        private File perfettoScript;
        private List<File> tempFiles = new ArrayList<File>();

        private DeviceTraceMetadata() {
        }

        public Process getProcess() {
            return this.process;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public File getTraceConfig() {
            return this.traceConfig;
        }

        public void setTraceConfig(File traceConfig, boolean needToDelete) {
            this.traceConfig = traceConfig;
            if (needToDelete) {
                this.tempFiles.add(traceConfig);
            }
        }

        public File getTraceOutput() {
            return this.traceOutput;
        }

        public void setTraceOutput(File traceOutput, boolean needToDelete) {
            this.traceOutput = traceOutput;
            if (needToDelete) {
                this.tempFiles.add(traceOutput);
            }
        }

        public File getPerfettoScript() {
            return this.perfettoScript;
        }

        public void setPerfettoScript(File perfettoScript, boolean needToDelete) {
            this.perfettoScript = perfettoScript;
            if (needToDelete) {
                this.tempFiles.add(perfettoScript);
            }
        }

        public void cleanUp() {
            for (File file2 : this.tempFiles) {
                FileUtil.deleteFile(file2);
            }
        }
    }
}

