/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.Message;
import com.android.tradefed.log.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ProtoUtil {
    public static List<String> getNestedFieldFromMessageAsStrings(Message message2, List<String> references) {
        return ProtoUtil.getNestedFieldFromMessageAsStringsHelper(message2, references);
    }

    private static List<String> getNestedFieldFromMessageAsStringsHelper(Object messageOrObject, List<String> references) {
        if (references.isEmpty()) {
            return Arrays.asList(String.valueOf(messageOrObject));
        }
        if (!(messageOrObject instanceof Message)) {
            LogUtil.CLog.e("Attempting to read field %s from object of type %s, which is not a proto message.", references.get(0), messageOrObject.getClass());
            return new ArrayList<String>();
        }
        Message message2 = (Message)messageOrObject;
        String reference = references.get(0);
        Descriptors.FieldDescriptor fieldDescriptor = message2.getDescriptorForType().findFieldByName(reference);
        if (fieldDescriptor == null) {
            LogUtil.CLog.e("Could not find field %s in message %s.", reference, message2);
            return new ArrayList<String>();
        }
        Object fieldValue = message2.getField(fieldDescriptor);
        if (fieldValue instanceof List) {
            return ((List)fieldValue).stream().flatMap(v -> ProtoUtil.getNestedFieldFromMessageAsStringsHelper(v, references.subList(1, references.size())).stream()).collect(Collectors.toList());
        }
        return ProtoUtil.getNestedFieldFromMessageAsStringsHelper(fieldValue, references.subList(1, references.size()));
    }
}

