/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotationAwareTokenizer {
    public static String[] tokenizeLine(String line, String delim, boolean logging) throws IllegalArgumentException {
        if (line == null) {
            throw new IllegalArgumentException("line is null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        Pattern charPattern = Pattern.compile("\\\\.|.");
        Matcher charMatcher = charPattern.matcher(line);
        String aChar = "";
        boolean quotation = false;
        QuotationAwareTokenizer.log(String.format("Trying to tokenize the line '%s'", line), logging);
        while (charMatcher.find()) {
            aChar = charMatcher.group();
            if (delim.equals(aChar)) {
                if (quotation) {
                    token.append(aChar);
                    continue;
                }
                if (token.length() <= 0) continue;
                QuotationAwareTokenizer.log(String.format("Finished token '%s'", token.toString()), logging);
                if (token.toString().equals("''")) {
                    tokens.add("");
                } else {
                    tokens.add(token.toString());
                }
                token.delete(0, token.length());
                continue;
            }
            if ("\"".equals(aChar)) {
                QuotationAwareTokenizer.log("Flipped quotation state", logging);
                quotation ^= true;
                continue;
            }
            token.append(aChar);
        }
        if (quotation || "\\".equals(aChar)) {
            throw new HarnessRuntimeException("Unexpected EOL in a quotation or after an escape character", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (token.length() > 0) {
            QuotationAwareTokenizer.log(String.format("Finished final token '%s'", token.toString()), logging);
            if (token.toString().equals("''")) {
                tokens.add("");
            } else {
                tokens.add(token.toString());
            }
            token.delete(0, token.length());
        }
        String[] tokensArray = new String[tokens.size()];
        return tokens.toArray(tokensArray);
    }

    public static String[] tokenizeLine(String line) {
        return QuotationAwareTokenizer.tokenizeLine(line, " ", true);
    }

    public static String[] tokenizeLine(String line, String delim) {
        return QuotationAwareTokenizer.tokenizeLine(line, delim, true);
    }

    public static String[] tokenizeLine(String line, boolean logging) {
        return QuotationAwareTokenizer.tokenizeLine(line, " ", logging);
    }

    public static String combineTokens(String ... tokens) {
        Pattern wsPattern = Pattern.compile("\\s");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            Matcher wsMatcher = wsPattern.matcher(token);
            if (wsMatcher.find()) {
                sb.append('\"');
                sb.append(token);
                sb.append('\"');
            } else {
                sb.append(token);
            }
            if (i >= tokens.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static void log(String message2, boolean display) {
        if (display) {
            LogUtil.CLog.v(message2);
        }
    }
}

