/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.build.cache.PartialZipDownloadCache;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.invoker.tracing.TracePropagatingExecutorService;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.zip.CentralDirectoryInfo;
import com.android.tradefed.util.zip.EndCentralDirectoryInfo;
import com.android.tradefed.util.zip.LocalFileHeader;
import com.android.tradefed.util.zip.MergedZipEntryCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class RemoteZip {
    private static final int POOL_MAX_SIZE = 8;
    private String mRemoteFilePath;
    private List<CentralDirectoryInfo> mZipEntries;
    private long mFileSize;
    private IFileDownloader mDownloader;
    private long mLastAccess;
    private boolean mUseZip64;
    private boolean mUseCache;

    public RemoteZip(String remoteFilePath, long fileSize, IFileDownloader downloader, boolean useZip64, boolean useCache) {
        this.mRemoteFilePath = remoteFilePath;
        this.mFileSize = fileSize;
        this.mDownloader = downloader;
        this.mZipEntries = null;
        this.mUseZip64 = useZip64;
        this.mLastAccess = System.currentTimeMillis();
        this.mUseCache = useCache;
    }

    public RemoteZip(String remoteFilePath, long fileSize, IFileDownloader downloader, boolean useZip64) {
        this(remoteFilePath, fileSize, downloader, useZip64, false);
    }

    public RemoteZip(String remoteFilePath, long fileSize, IFileDownloader downloader) {
        this(remoteFilePath, fileSize, downloader, false);
    }

    public String getRemoteFilePath() {
        return this.mRemoteFilePath;
    }

    public long getLastAccess() {
        return this.mLastAccess;
    }

    public void setLastAccess(long timestamp) {
        this.mLastAccess = timestamp;
    }

    public List<CentralDirectoryInfo> getZipEntries() throws BuildRetrievalError, IOException {
        if (this.mZipEntries != null) {
            return this.mZipEntries;
        }
        File partialZipFile = FileUtil.createTempFileForRemote(this.mRemoteFilePath, null);
        partialZipFile.delete();
        try {
            long size = 65536L;
            long startOffset = this.mFileSize - size;
            if (startOffset < 0L) {
                startOffset = 0L;
                size = -1L;
            }
            this.mDownloader.downloadFile(this.mRemoteFilePath, partialZipFile, startOffset, size);
            EndCentralDirectoryInfo endCentralDirInfo = new EndCentralDirectoryInfo(partialZipFile, this.mUseZip64);
            partialZipFile.delete();
            this.mDownloader.downloadFile(this.mRemoteFilePath, partialZipFile, endCentralDirInfo.getCentralDirOffset(), endCentralDirInfo.getCentralDirSize());
            List<CentralDirectoryInfo> list2 = this.mZipEntries = ZipUtil.getZipCentralDirectoryInfos(partialZipFile, endCentralDirInfo, this.mUseZip64);
            return list2;
        }
        catch (IOException e) {
            throw new BuildRetrievalError(String.format("Failed to get zip entries of remote file %s", this.mRemoteFilePath), e);
        }
        finally {
            FileUtil.deleteFile(partialZipFile);
        }
    }

    /*
     * Exception decompiling
     */
    public void downloadFiles(File destDir, List<CentralDirectoryInfo> originalFiles) throws BuildRetrievalError, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOException unzipDownloadedCollection(File destDir, File partialZipFile, MergedZipEntryCollection collection) {
        try {
            for (CentralDirectoryInfo entry : collection.getZipEntries()) {
                File targetFile = new File(Paths.get(destDir.toString(), entry.getFileName()).toString());
                if (targetFile.exists()) {
                    LogUtil.CLog.d("Downloaded %s already exists, skip partial unzip.", entry.getFileName());
                    continue;
                }
                try (CloseableTraceScope unzipTrace = new CloseableTraceScope("unzipPartialZipFile");){
                    LocalFileHeader localFileHeader = new LocalFileHeader(partialZipFile, entry.getLocalHeaderOffset() - collection.getStartOffset());
                    ZipUtil.unzipPartialZipFile(partialZipFile, targetFile, entry, localFileHeader, entry.getLocalHeaderOffset() - collection.getStartOffset());
                    LogUtil.CLog.d("Downloaded %s. unzipped size: %s", entry.getFileName(), targetFile.length());
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                    IOException iOException = e;
                    FileUtil.deleteFile(partialZipFile);
                    return iOException;
                }
                if (!this.mUseCache) continue;
                PartialZipDownloadCache.getDefaultCache().populateCacheFile(targetFile, entry.getFileName(), Long.toString(entry.getCrc()));
            }
            Iterator<CentralDirectoryInfo> iterator2 = null;
            return iterator2;
        }
        finally {
            FileUtil.deleteFile(partialZipFile);
        }
    }

    private /* synthetic */ Long lambda$downloadFiles$2(File downloadParentDir, MergedZipEntryCollection collection, TracePropagatingExecutorService service, File destDir, List futures) throws Exception {
        File partialZipFile = null;
        long downloadedSize = 0L;
        partialZipFile = FileUtil.createTempFileForRemote(this.mRemoteFilePath, downloadParentDir);
        partialZipFile.delete();
        downloadedSize = collection.getEndOffset() - collection.getStartOffset();
        if (collection.getStartOffset() + downloadedSize > this.mFileSize) {
            downloadedSize = this.mFileSize - collection.getStartOffset();
        }
        this.mDownloader.downloadFile(this.mRemoteFilePath, partialZipFile, collection.getStartOffset(), downloadedSize);
        File partialZipFinal = partialZipFile;
        Future<IOException> futureClient = service.submit(() -> this.unzipDownloadedCollection(destDir, partialZipFinal, collection));
        futures.add(futureClient);
        return downloadedSize;
    }

    private static /* synthetic */ void lambda$downloadFiles$0(File destDir, List skipDownloadName, List toBeDownloaded, CentralDirectoryInfo info) {
        File targetFile = new File(destDir, info.getFileName());
        if (targetFile.exists()) {
            skipDownloadName.add(info.getFileName());
        } else {
            toBeDownloaded.add(info);
        }
    }
}

