/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ResourceUtil {
    public static boolean extractResourceAsFile(String resource, File output) {
        boolean bl;
        block8: {
            InputStream resStream = ResourceUtil.class.getResourceAsStream(resource);
            try {
                FileUtil.writeToFile(resStream, output);
                bl = true;
                if (resStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resStream != null) {
                        try {
                            resStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    LogUtil.CLog.e(e);
                    return false;
                }
            }
            resStream.close();
        }
        return bl;
    }

    public static boolean extractResourceWithAltAsFile(String resource, String altResourcePath, File output) {
        if (ResourceUtil.extractResourceAsFile(resource, output)) {
            return true;
        }
        return ResourceUtil.extractResourceAsFile(altResourcePath, output);
    }

    public static Map<String, String> readConfigurationFromResource(String resource) {
        Map<String, String> map;
        block8: {
            InputStream resStream = ResourceUtil.class.getResourceAsStream(resource);
            try {
                map = ResourceUtil.readConfigurationFromStream(resStream);
                if (resStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resStream != null) {
                        try {
                            resStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                    return new HashMap<String, String>();
                }
            }
            resStream.close();
        }
        return map;
    }

    public static Map<String, String> readConfigurationFromFile(File propertyFile) {
        Map<String, String> map;
        FileInputStream resStream = new FileInputStream(propertyFile);
        try {
            map = ResourceUtil.readConfigurationFromStream(resStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)resStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                return new HashMap<String, String>();
            }
        }
        ((InputStream)resStream).close();
        return map;
    }

    public static Map<String, String> readConfigurationFromStream(InputStream propertyStream) {
        HashMap<String, String> resources = new HashMap<String, String>();
        try {
            if (propertyStream == null) {
                LogUtil.CLog.w("No configuration stream");
                return resources;
            }
            Properties properties = new Properties();
            properties.load(propertyStream);
            for (Object key : properties.keySet()) {
                String keyString = (String)key;
                String valueString = (String)properties.get(key);
                if (Strings.isNullOrEmpty(valueString)) continue;
                resources.put(keyString, valueString);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        return resources;
    }
}

