/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.GoogleApiClientUtil;
import com.android.tradefed.util.IRestApiHelper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ExponentialBackOff;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import org.json.JSONObject;

public class RestApiHelper
implements IRestApiHelper {
    protected static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    protected static final String JSON_MIME = "application/json";
    protected static final int DEFAULT_NUMBER_OF_RETRIES = 2;
    private HttpRequestFactory mRequestFactory;
    private String mBaseUri;

    public RestApiHelper(HttpRequestFactory requestFactory, String baseUri) {
        this.mRequestFactory = requestFactory;
        this.mBaseUri = baseUri.endsWith("/") ? baseUri : baseUri + "/";
    }

    @Deprecated
    public static RestApiHelper newInstanceWithGoogleCredential(String baseUri, String serviceAccount, File keyFile, Collection<String> scopes) throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        Credential credential = GoogleApiClientUtil.createCredentialFromP12File(serviceAccount, keyFile, scopes);
        HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
        return new RestApiHelper(requestFactory, baseUri);
    }

    public static RestApiHelper newInstanceWithGoogleCredential(String baseUri, File jsonKeyFile, Collection<String> scopes) throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        Credential credential = GoogleApiClientUtil.createCredentialFromJsonKeyFile(jsonKeyFile, scopes);
        HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
        return new RestApiHelper(requestFactory, baseUri);
    }

    @Override
    public HttpResponse execute(String method, String[] uriParts, Map<String, Object> options, JSONObject data) throws IOException {
        ByteArrayContent content = null;
        if (data != null) {
            content = new ByteArrayContent(JSON_MIME, data.toString().getBytes());
        }
        GenericUrl uri = this.buildQueryUri(uriParts, options);
        HttpRequest request = this.getRequestFactory().buildRequest(method, uri, content);
        request.setParser(new JsonObjectParser(JSON_FACTORY));
        request.setNumberOfRetries(2);
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(new ExponentialBackOff()));
        return request.execute();
    }

    @VisibleForTesting
    public HttpRequestFactory getRequestFactory() {
        return this.mRequestFactory;
    }

    public GenericUrl buildQueryUri(String[] uriParts, Map<String, Object> options) {
        GenericUrl uri = new GenericUrl(this.mBaseUri);
        for (int i = 0; i < uriParts.length; ++i) {
            uri.appendRawPath(uriParts[i]);
            if (i + 1 >= uriParts.length) continue;
            uri.appendRawPath("/");
        }
        if (options != null) {
            uri.putAll((Map<? extends String, ?>)options);
        }
        return uri;
    }
}

