/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.command.CommandInterrupter;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunInterruptedException;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class RunUtil
implements IRunUtil {
    public static final String RUNNABLE_NOTIFIER_NAME = "RunnableNotifier";
    public static final String INHERITIO_PREFIX = "inheritio-";
    private static final int POLL_TIME_INCREASE_FACTOR = 4;
    private static final long THREAD_JOIN_POLL_INTERVAL = 30000L;
    private static final long PROCESS_DESTROY_TIMEOUT_SEC = 2L;
    private static IRunUtil sDefaultInstance = null;
    private File mWorkingDir = null;
    private Map<String, String> mEnvVariables = new HashMap<String, String>();
    private Set<String> mUnsetEnvVariables = new HashSet<String>();
    private IRunUtil.EnvPriority mEnvVariablePriority = IRunUtil.EnvPriority.UNSET;
    private boolean mRedirectStderr = false;
    private boolean mLinuxInterruptProcess = false;
    private final CommandInterrupter mInterrupter;

    public RunUtil() {
        this(CommandInterrupter.INSTANCE);
    }

    @VisibleForTesting
    RunUtil(@Nonnull CommandInterrupter interrupter) {
        this.mInterrupter = interrupter;
    }

    public static IRunUtil getDefault() {
        if (sDefaultInstance == null) {
            sDefaultInstance = new RunUtil();
        }
        return sDefaultInstance;
    }

    @Override
    public synchronized void setWorkingDir(File dir) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot setWorkingDir on default RunUtil");
        }
        this.mWorkingDir = dir;
    }

    @Override
    public synchronized void setEnvVariable(String name, String value) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot setEnvVariable on default RunUtil");
        }
        this.mEnvVariables.put(name, value);
    }

    @Override
    public synchronized void unsetEnvVariable(String key) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot unsetEnvVariable on default RunUtil");
        }
        this.mUnsetEnvVariables.add(key);
    }

    @Override
    public void setRedirectStderrToStdout(boolean redirect) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot setRedirectStderrToStdout on default RunUtil");
        }
        this.mRedirectStderr = redirect;
    }

    @Override
    public CommandResult runTimedCmd(long timeout, String ... command) {
        return this.runTimedCmd(timeout, (OutputStream)null, (OutputStream)null, command);
    }

    @Override
    public CommandResult runTimedCmd(long timeout, OutputStream stdout, OutputStream stderr, String ... command) {
        RunnableResult osRunnable = this.createRunnableResult(stdout, stderr, command);
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        CommandResult result = osRunnable.getResult();
        result.setStatus(status);
        return result;
    }

    @VisibleForTesting
    RunnableResult createRunnableResult(OutputStream stdout, OutputStream stderr, String ... command) {
        return new RunnableResult(null, this.createProcessBuilder(command), stdout, stderr, null, false);
    }

    @Override
    public CommandResult runTimedCmdRetry(long timeout, long retryInterval, int attempts, String ... command) {
        CommandResult result = null;
        for (int counter = 0; counter < attempts; ++counter) {
            result = this.runTimedCmd(timeout, command);
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                return result;
            }
            this.sleep(retryInterval);
        }
        return result;
    }

    private synchronized ProcessBuilder createProcessBuilder(String ... command) {
        return this.createProcessBuilder(Arrays.asList(command));
    }

    private synchronized ProcessBuilder createProcessBuilder(ProcessBuilder.Redirect redirect, String ... command) {
        return this.createProcessBuilder(redirect, Arrays.asList(command));
    }

    private synchronized ProcessBuilder createProcessBuilder(List<String> commandList) {
        return this.createProcessBuilder(null, commandList);
    }

    private synchronized ProcessBuilder createProcessBuilder(ProcessBuilder.Redirect redirect, List<String> commandList) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.mWorkingDir != null) {
            processBuilder.directory(this.mWorkingDir);
        }
        if (IRunUtil.EnvPriority.UNSET.equals((Object)this.mEnvVariablePriority)) {
            if (!this.mEnvVariables.isEmpty()) {
                processBuilder.environment().putAll(this.mEnvVariables);
            }
            if (!this.mUnsetEnvVariables.isEmpty()) {
                processBuilder.environment().keySet().removeAll(this.mUnsetEnvVariables);
            }
        } else {
            if (!this.mUnsetEnvVariables.isEmpty()) {
                processBuilder.environment().keySet().removeAll(this.mUnsetEnvVariables);
            }
            if (!this.mEnvVariables.isEmpty()) {
                processBuilder.environment().putAll(this.mEnvVariables);
            }
        }
        processBuilder.redirectErrorStream(this.mRedirectStderr);
        if (redirect != null) {
            processBuilder.redirectOutput(redirect);
            processBuilder.redirectError(redirect);
        }
        return processBuilder.command(commandList);
    }

    @Override
    public CommandResult runTimedCmdWithInput(long timeout, String input, String ... command) {
        return this.runTimedCmdWithInput(timeout, input, ArrayUtil.list(command));
    }

    @Override
    public CommandResult runTimedCmdWithInput(long timeout, String input, List<String> command) {
        RunnableResult osRunnable = new RunnableResult(input, this.createProcessBuilder(command));
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        CommandResult result = osRunnable.getResult();
        result.setStatus(status);
        return result;
    }

    @Override
    public CommandResult runTimedCmdWithInput(long timeout, String input, File stdoutFile, File stderrFile, String ... command) {
        ProcessBuilder pb = this.createProcessBuilder(command);
        pb.redirectOutput(ProcessBuilder.Redirect.to(stdoutFile));
        pb.redirectError(ProcessBuilder.Redirect.to(stderrFile));
        RunnableResult osRunnable = new RunnableResult(input, pb);
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        CommandResult result = osRunnable.getResult();
        result.setStatus(status);
        if (result.getExitCode() == 88) {
            try {
                FileUtil.writeToFile(result.getStderr(), stderrFile, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public CommandResult runTimedCmdWithInputRedirect(long timeout, File inputRedirect, String ... command) {
        RunnableResult osRunnable = new RunnableResult(null, this.createProcessBuilder(command), null, null, inputRedirect, true);
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        CommandResult result = osRunnable.getResult();
        result.setStatus(status);
        return result;
    }

    @Override
    public CommandResult runTimedCmdSilently(long timeout, String ... command) {
        RunnableResult osRunnable = new RunnableResult(null, this.createProcessBuilder(command), false);
        CommandStatus status = this.runTimed(timeout, osRunnable, false);
        CommandResult result = osRunnable.getResult();
        result.setStatus(status);
        return result;
    }

    @Override
    public CommandResult runTimedCmdSilentlyRetry(long timeout, long retryInterval, int attempts, String ... command) {
        CommandResult result = null;
        for (int counter = 0; counter < attempts; ++counter) {
            result = this.runTimedCmdSilently(timeout, command);
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                return result;
            }
            this.sleep(retryInterval);
        }
        return result;
    }

    @Override
    public Process runCmdInBackground(String ... command) throws IOException {
        return this.runCmdInBackground((ProcessBuilder.Redirect)null, command);
    }

    @Override
    public Process runCmdInBackground(ProcessBuilder.Redirect redirect, String ... command) throws IOException {
        String fullCmd = Arrays.toString(command);
        LogUtil.CLog.v("Running in background: %s", fullCmd);
        return this.createProcessBuilder(redirect, command).start();
    }

    @Override
    public Process runCmdInBackground(List<String> command) throws IOException {
        return this.runCmdInBackground(null, command);
    }

    @Override
    public Process runCmdInBackground(ProcessBuilder.Redirect redirect, List<String> command) throws IOException {
        LogUtil.CLog.v("Running in background: %s", command);
        return this.createProcessBuilder(redirect, command).start();
    }

    @Override
    public Process runCmdInBackground(List<String> command, OutputStream output) throws IOException {
        LogUtil.CLog.v("Running in background: %s", command);
        Process process = this.createProcessBuilder(command).start();
        RunUtil.inheritIO(process.getInputStream(), output, String.format("inheritio-stdout-%s", command));
        RunUtil.inheritIO(process.getErrorStream(), output, String.format("inheritio-stderr-%s", command));
        return process;
    }

    @Override
    public CommandStatus runTimed(long timeout, IRunUtil.IRunnableResult runnable, boolean logErrors) {
        this.mInterrupter.checkInterrupted();
        RunnableNotifier runThread = new RunnableNotifier(runnable, logErrors);
        if (logErrors) {
            if (timeout > 0L) {
                LogUtil.CLog.d("Running command %s with timeout: %s", runnable.getCommand(), TimeUtil.formatElapsedTime(timeout));
            } else {
                LogUtil.CLog.d("Running command %s without timeout.", runnable.getCommand());
            }
        }
        CommandStatus status = CommandStatus.TIMED_OUT;
        try {
            runThread.start();
            long startTime = System.currentTimeMillis();
            long pollInterval = 0L;
            pollInterval = timeout > 0L && timeout < 30000L ? timeout : 30000L;
            do {
                try {
                    runThread.join(pollInterval);
                }
                catch (InterruptedException e) {
                    if (this.isInterruptAllowed()) {
                        LogUtil.CLog.i("runTimed: interrupted while joining the runnable");
                        break;
                    }
                    LogUtil.CLog.i("runTimed: currently uninterruptible, ignoring interrupt");
                }
                this.mInterrupter.checkInterrupted();
            } while ((timeout == 0L || System.currentTimeMillis() - startTime < timeout) && runThread.isAlive());
        }
        catch (RunInterruptedException e) {
            try {
                runThread.cancel();
                throw e;
            }
            catch (Throwable throwable) {
                status = runThread.getStatus();
                if (CommandStatus.TIMED_OUT.equals((Object)status) || CommandStatus.EXCEPTION.equals((Object)status)) {
                    LogUtil.CLog.i("runTimed: Calling interrupt, status is %s", new Object[]{status});
                    runThread.cancel();
                }
                throw throwable;
            }
        }
        status = runThread.getStatus();
        if (CommandStatus.TIMED_OUT.equals((Object)status) || CommandStatus.EXCEPTION.equals((Object)status)) {
            LogUtil.CLog.i("runTimed: Calling interrupt, status is %s", new Object[]{status});
            runThread.cancel();
        }
        this.mInterrupter.checkInterrupted();
        return status;
    }

    @Override
    public boolean runTimedRetry(long opTimeout, long pollInterval, int attempts, IRunUtil.IRunnableResult runnable) {
        for (int i = 0; i < attempts; ++i) {
            if (this.runTimed(opTimeout, runnable, true) == CommandStatus.SUCCESS) {
                return true;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
        }
        return false;
    }

    @Override
    public boolean runFixedTimedRetry(long opTimeout, long pollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long initialTime = this.getCurrentTime();
        while (this.getCurrentTime() < initialTime + maxTime) {
            if (this.runTimed(opTimeout, runnable, true) == CommandStatus.SUCCESS) {
                return true;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
        }
        return false;
    }

    @Override
    public boolean runEscalatingTimedRetry(long opTimeout, long initialPollInterval, long maxPollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long pollInterval = initialPollInterval;
        long initialTime = this.getCurrentTime();
        while (this.runTimed(opTimeout, runnable, true) != CommandStatus.SUCCESS) {
            long remainingTime = maxTime - (this.getCurrentTime() - initialTime);
            if (remainingTime <= 0L) {
                LogUtil.CLog.d("operation is still failing after retrying for %d ms", maxTime);
                return false;
            }
            if (remainingTime < pollInterval) {
                pollInterval = remainingTime;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
            if ((pollInterval *= 4L) <= maxPollInterval) continue;
            pollInterval = maxPollInterval;
        }
        return true;
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void sleep(long time) {
        this.mInterrupter.checkInterrupted();
        if (time <= 0L) {
            return;
        }
        try (CloseableTraceScope sleep = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.host_sleep.toString());){
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.d("sleep interrupted");
        }
        this.mInterrupter.checkInterrupted();
    }

    @Override
    public void allowInterrupt(boolean allow) {
        if (allow) {
            this.mInterrupter.allowInterrupt();
        } else {
            this.mInterrupter.blockInterrupt();
        }
    }

    @Override
    public boolean isInterruptAllowed() {
        return this.mInterrupter.isInterruptible();
    }

    @Override
    public void setInterruptibleInFuture(Thread thread, long timeMs) {
        this.mInterrupter.allowInterruptAsync(thread, timeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void interrupt(Thread thread, String message2) {
        this.interrupt(thread, message2, null);
    }

    @Override
    public synchronized void interrupt(Thread thread, String message2, ErrorIdentifier errorId) {
        this.mInterrupter.interrupt(thread, message2, errorId);
        this.mInterrupter.checkInterrupted();
    }

    private static Thread inheritIO(final InputStream src, final OutputStream dest, final String name) {
        if (src == null) {
            return null;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StreamUtil.copyStreams(src, dest);
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Failed to read input stream %s.", name);
                }
            }
        });
        t.setName(name);
        t.start();
        return t;
    }

    @Override
    public void setEnvVariablePriority(IRunUtil.EnvPriority priority) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot setEnvVariablePriority on default RunUtil");
        }
        this.mEnvVariablePriority = priority;
    }

    @Override
    public void setLinuxInterruptProcess(boolean interrupt) {
        if (this.equals(sDefaultInstance)) {
            throw new UnsupportedOperationException("Cannot setLinuxInterruptProcess on default RunUtil");
        }
        this.mLinuxInterruptProcess = interrupt;
    }

    class RunnableResult
    implements IRunUtil.IRunnableResult {
        private final ProcessBuilder mProcessBuilder;
        private final CommandResult mCommandResult;
        private final String mInput;
        private Process mProcess = null;
        private CountDownLatch mCountDown = null;
        private Thread mExecutionThread;
        private OutputStream mStdOut = null;
        private OutputStream mStdErr = null;
        private final File mInputRedirect;
        private final Object mLock = new Object();
        private boolean mCancelled = false;
        private boolean mLogErrors = true;

        RunnableResult(String input, ProcessBuilder processBuilder) {
            this(input, processBuilder, null, null, null, true);
        }

        RunnableResult(String input, ProcessBuilder processBuilder, boolean logErrors) {
            this(input, processBuilder, null, null, null, logErrors);
        }

        RunnableResult(String input, ProcessBuilder processBuilder, OutputStream stdoutStream, OutputStream stderrStream, File inputRedirect, boolean logErrors) {
            this.mProcessBuilder = processBuilder;
            this.mInput = input;
            this.mLogErrors = logErrors;
            this.mInputRedirect = inputRedirect;
            if (this.mInputRedirect != null) {
                this.mProcessBuilder.redirectInput(this.mInputRedirect);
            }
            this.mCommandResult = new CommandResult();
            this.mCommandResult.setStdout("");
            this.mCommandResult.setStderr("");
            this.mCountDown = new CountDownLatch(1);
            this.mStdOut = stdoutStream;
            this.mStdErr = stderrStream;
        }

        @Override
        public List<String> getCommand() {
            return new ArrayList<String>(this.mProcessBuilder.command());
        }

        @Override
        public CommandResult getResult() {
            return this.mCommandResult;
        }

        @VisibleForTesting
        Process startProcess() throws IOException {
            return this.mProcessBuilder.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run() throws Exception {
            File stdoutFile = this.mProcessBuilder.redirectOutput().file();
            File stderrFile = this.mProcessBuilder.redirectError().file();
            boolean temporaryStdout = false;
            boolean temporaryErrOut = false;
            Thread stdoutThread = null;
            Thread stderrThread = null;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCancelled) {
                    return false;
                }
                this.mExecutionThread = Thread.currentThread();
                if (stdoutFile == null && this.mStdOut == null) {
                    temporaryStdout = true;
                    stdoutFile = FileUtil.createTempFile(String.format("temporary-stdout-%s", this.mProcessBuilder.command().get(0)), ".txt");
                    stdoutFile.deleteOnExit();
                    this.mProcessBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(stdoutFile));
                }
                if (stderrFile == null && this.mStdErr == null) {
                    temporaryErrOut = true;
                    stderrFile = FileUtil.createTempFile(String.format("temporary-errout-%s", this.mProcessBuilder.command().get(0)), ".txt");
                    stderrFile.deleteOnExit();
                    this.mProcessBuilder.redirectError(ProcessBuilder.Redirect.appendTo(stderrFile));
                }
                try {
                    this.mProcess = this.startProcess();
                }
                catch (IOException | RuntimeException e) {
                    if (temporaryStdout) {
                        FileUtil.deleteFile(stdoutFile);
                    }
                    if (temporaryErrOut) {
                        FileUtil.deleteFile(stderrFile);
                    }
                    throw e;
                }
                if (this.mInput != null) {
                    BufferedOutputStream processStdin = new BufferedOutputStream(this.mProcess.getOutputStream());
                    processStdin.write(this.mInput.getBytes("UTF-8"));
                    processStdin.flush();
                    processStdin.close();
                }
                if (this.mStdOut != null) {
                    stdoutThread = RunUtil.inheritIO(this.mProcess.getInputStream(), this.mStdOut, String.format("inheritio-stdout-%s", this.mProcessBuilder.command()));
                }
                if (this.mStdErr != null) {
                    stderrThread = RunUtil.inheritIO(this.mProcess.getErrorStream(), this.mStdErr, String.format("inheritio-stderr-%s", this.mProcessBuilder.command()));
                }
            }
            Integer rc = null;
            try {
                try {
                    rc = this.mProcess.waitFor();
                    if (stdoutThread != null) {
                        stdoutThread.join();
                    }
                    if (stderrThread != null) {
                        stderrThread.join();
                    }
                    rc = rc != null ? rc : 1;
                }
                catch (Throwable throwable) {
                    rc = rc != null ? rc : 1;
                    this.mCommandResult.setExitCode(rc);
                    if (temporaryStdout) {
                        this.mCommandResult.setStdout(FileUtil.readStringFromFile(stdoutFile));
                    } else {
                        String stdoutDest = stdoutFile != null ? stdoutFile.getAbsolutePath() : this.mStdOut.getClass().getSimpleName();
                        this.mCommandResult.setStdout("redirected to " + stdoutDest);
                    }
                    if (temporaryErrOut) {
                        this.mCommandResult.setStderr(FileUtil.readStringFromFile(stderrFile));
                    } else {
                        String stderrDest = stderrFile != null ? stderrFile.getAbsolutePath() : this.mStdErr.getClass().getSimpleName();
                        this.mCommandResult.setStderr("redirected to " + stderrDest);
                    }
                    throw throwable;
                }
                this.mCommandResult.setExitCode(rc);
                if (temporaryStdout) {
                    this.mCommandResult.setStdout(FileUtil.readStringFromFile(stdoutFile));
                } else {
                    String stdoutDest = stdoutFile != null ? stdoutFile.getAbsolutePath() : this.mStdOut.getClass().getSimpleName();
                    this.mCommandResult.setStdout("redirected to " + stdoutDest);
                }
                if (temporaryErrOut) {
                    this.mCommandResult.setStderr(FileUtil.readStringFromFile(stderrFile));
                } else {
                    String stderrDest = stderrFile != null ? stderrFile.getAbsolutePath() : this.mStdErr.getClass().getSimpleName();
                    this.mCommandResult.setStderr("redirected to " + stderrDest);
                }
            }
            finally {
                if (temporaryStdout) {
                    FileUtil.deleteFile(stdoutFile);
                }
                if (temporaryErrOut) {
                    FileUtil.deleteFile(stderrFile);
                }
                this.mCountDown.countDown();
            }
            if (rc != null && rc == 0) {
                return true;
            }
            if (this.mLogErrors) {
                LogUtil.CLog.d("%s command failed. return code %d", this.mProcessBuilder.command(), rc);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (this.mCancelled) {
                return;
            }
            this.mCancelled = true;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mProcess == null || !this.mProcess.isAlive()) {
                    return;
                }
                LogUtil.CLog.d("Cancelling the process execution.");
                if (RunUtil.this.mLinuxInterruptProcess) {
                    long pid = this.mProcess.pid();
                    CommandResult killRes = RunUtil.getDefault().runTimedCmd(60000L, "kill", "-2", "" + pid);
                    LogUtil.CLog.d("status=%s. stdout=%s . stderr=%s", new Object[]{killRes.getStatus(), killRes.getStdout(), killRes.getStderr()});
                    if (this.mProcess.isAlive()) {
                        RunUtil.getDefault().sleep(1000L);
                    }
                }
                this.mProcess.destroy();
                try {
                    if (!this.mCountDown.await(2L, TimeUnit.SECONDS)) {
                        LogUtil.CLog.i("Process still not terminated, interrupting the execution thread");
                        this.mExecutionThread.interrupt();
                        this.mCountDown.await();
                    }
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.i("interrupted while waiting for process output to be saved");
                }
            }
        }

        public String toString() {
            return "RunnableResult [command=" + (this.mProcessBuilder != null ? this.mProcessBuilder.command() : null) + "]";
        }
    }

    private static class RunnableNotifier
    extends Thread {
        private final IRunUtil.IRunnableResult mRunnable;
        private CommandStatus mStatus = CommandStatus.TIMED_OUT;
        private boolean mLogErrors = true;

        RunnableNotifier(IRunUtil.IRunnableResult runnable, boolean logErrors) {
            this.setName(RunUtil.RUNNABLE_NOTIFIER_NAME);
            this.setDaemon(true);
            this.mRunnable = runnable;
            this.mLogErrors = logErrors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandStatus status;
            try {
                status = this.mRunnable.run() ? CommandStatus.SUCCESS : CommandStatus.FAILED;
            }
            catch (InterruptedException e) {
                LogUtil.CLog.i("runutil interrupted");
                status = CommandStatus.EXCEPTION;
                this.backFillException(this.mRunnable.getResult(), e);
            }
            catch (Exception e) {
                if (this.mLogErrors) {
                    LogUtil.CLog.e("Exception occurred when executing runnable");
                    LogUtil.CLog.e(e);
                }
                status = CommandStatus.EXCEPTION;
                this.backFillException(this.mRunnable.getResult(), e);
            }
            RunnableNotifier runnableNotifier = this;
            synchronized (runnableNotifier) {
                this.mStatus = status;
            }
        }

        public void cancel() {
            this.mRunnable.cancel();
        }

        synchronized CommandStatus getStatus() {
            return this.mStatus;
        }

        private void backFillException(CommandResult result, Exception e) {
            if (result == null) {
                return;
            }
            if (Strings.isNullOrEmpty(result.getStderr())) {
                result.setStderr(StreamUtil.getStackTrace(e));
            }
            if (result.getExitCode() == null) {
                result.setExitCode(88);
            }
        }
    }
}

