/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class SerializationUtil {
    public static File serialize(Serializable o) throws IOException {
        File tmpSerialized = FileUtil.createTempFile("serial-util", ".ser");
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(tmpSerialized);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(o);
        }
        catch (IOException e) {
            try {
                FileUtil.deleteFile(tmpSerialized);
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                StreamUtil.close(fileOut);
                throw throwable;
            }
        }
        StreamUtil.close(out);
        StreamUtil.close(fileOut);
        return tmpSerialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeToString(Serializable o) throws IOException {
        String string;
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        try {
            byteOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(byteOut);
            out.writeObject(o);
            string = Base64.getEncoder().encodeToString(byteOut.toByteArray());
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            StreamUtil.close(byteOut);
            throw throwable;
        }
        StreamUtil.close(out);
        StreamUtil.close(byteOut);
        return string;
    }

    public static Object deserialize(String serialized) throws IOException {
        Object object;
        ByteArrayInputStream bais = null;
        ObjectInputStream in = null;
        try {
            bais = new ByteArrayInputStream(Base64.getDecoder().decode(serialized));
            in = new ObjectInputStream(bais);
            object = in.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                throw new RuntimeException(cnfe);
            }
            catch (Throwable throwable) {
                StreamUtil.close(in);
                StreamUtil.close(bais);
                throw throwable;
            }
        }
        StreamUtil.close(in);
        StreamUtil.close(bais);
        return object;
    }

    public static Object deserialize(File serializedFile, boolean deleteFile) throws IOException {
        Object object;
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        try {
            fileIn = new FileInputStream(serializedFile);
            in = new ObjectInputStream(fileIn);
            object = in.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                throw new RuntimeException(cnfe);
            }
            catch (Throwable throwable) {
                StreamUtil.close(in);
                StreamUtil.close(fileIn);
                if (deleteFile) {
                    FileUtil.deleteFile(serializedFile);
                }
                throw throwable;
            }
        }
        StreamUtil.close(in);
        StreamUtil.close(fileIn);
        if (deleteFile) {
            FileUtil.deleteFile(serializedFile);
        }
        return object;
    }
}

