/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public final class ShellOutputReceiverStream
extends OutputStream {
    private IShellOutputReceiver mReceiver;
    private FileOutputStream mFileOutput;

    public ShellOutputReceiverStream(@Nullable IShellOutputReceiver receiver) {
        this.mReceiver = receiver;
    }

    public ShellOutputReceiverStream(@Nullable IShellOutputReceiver receiver, @Nullable FileOutputStream fileOutput) {
        this(receiver);
        this.mFileOutput = fileOutput;
    }

    @Override
    public void write(int b) {
        if (this.mReceiver == null) {
            return;
        }
        byte converted = (byte)(b & 0xFF);
        this.mReceiver.addOutput(new byte[]{converted}, 0, 1);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.mReceiver == null) {
            return;
        }
        this.mReceiver.addOutput(b, off, len);
        if (this.mFileOutput != null) {
            try {
                this.mFileOutput.write(b, off, len);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.mReceiver == null) {
            return;
        }
        this.mReceiver.flush();
        if (this.mFileOutput != null) {
            this.mFileOutput.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        StreamUtil.close(this.mFileOutput);
    }
}

