/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.SimplePerfResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SimplePerfStatResultParser {
    private static final String SIMPLEPERF_METRIC_HEAD = "Performance counter statistics:";
    private static final Pattern TOTAL_TIME_SENTENCE_PATTERN = Pattern.compile("Total test time: (\\d+\\.\\d+) seconds.");
    private static final Pattern TOTAL_METRIC_SENTENCE_PATTERN = Pattern.compile("\\s*([0-9,\\.]*?)(\\(ms\\))?\\s+([0-9a-z_:-]*?)\\s+#\\s+([^#]*)");

    private SimplePerfStatResultParser() {
    }

    public static List<String> parseSingleLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        if (line == null) {
            return result;
        }
        if (line.contains(SIMPLEPERF_METRIC_HEAD) || line.equals("")) {
            return result;
        }
        Matcher matcher = TOTAL_TIME_SENTENCE_PATTERN.matcher(line);
        if (matcher.matches()) {
            result.add(matcher.group(1));
            return result;
        }
        matcher = TOTAL_METRIC_SENTENCE_PATTERN.matcher(line);
        if (matcher.matches()) {
            result.add(matcher.group(1));
            result.add(matcher.group(3));
            result.add(matcher.group(4));
        }
        return result;
    }

    public static SimplePerfResult parseRawOutput(String output) {
        String[] lines;
        SimplePerfResult result = new SimplePerfResult();
        if (output == null) {
            return null;
        }
        int idx = output.indexOf(SIMPLEPERF_METRIC_HEAD);
        if (idx == -1) {
            LogUtil.CLog.e("Cannot find simpleperf metric head message");
            return null;
        }
        result.setCommandRawOutput(output.substring(0, idx));
        String simpleperfOutput = output.substring(idx + SIMPLEPERF_METRIC_HEAD.length() + 1);
        result.setSimplePerfRawOutput(simpleperfOutput);
        for (String line : lines = simpleperfOutput.split("\n")) {
            List<String> singleLineResults = SimplePerfStatResultParser.parseSingleLine(line);
            if (singleLineResults.size() == 1) {
                result.setTotalTestTime(singleLineResults.get(0));
                continue;
            }
            if (singleLineResults.size() == 3) {
                result.addBenchmarkComment(singleLineResults.get(1), singleLineResults.get(2));
                result.addBenchmarkMetrics(singleLineResults.get(1), singleLineResults.get(0));
                continue;
            }
            LogUtil.CLog.i("Line skipped. " + line);
        }
        return result;
    }
}

