/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.SimplePerfResult;
import com.android.tradefed.util.SimplePerfStatResultParser;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class SimplePerfUtil {
    private ITestDevice mDevice;
    private SimplePerfType mType;
    private List<String> mArguList;
    private StringBuilder mCachedCommandPrepend;

    private SimplePerfUtil(ITestDevice device, SimplePerfType type) {
        this.mDevice = device;
        this.mType = type;
        this.mCachedCommandPrepend = null;
    }

    public static SimplePerfUtil newInstance(ITestDevice device, SimplePerfType type) throws NullPointerException {
        if (device == null || type == null) {
            throw new NullPointerException();
        }
        return new SimplePerfUtil(device, type);
    }

    public List<String> getArgumentList() {
        return this.mArguList;
    }

    public void setArgumentList(List<String> arguList) {
        this.mArguList = arguList;
        this.mCachedCommandPrepend = null;
    }

    public SimplePerfResult executeCommand(String command) throws DeviceNotAvailableException {
        String output = this.mDevice.executeShellCommand(this.commandStringPreparer(command));
        Assert.assertNotNull("ExecuteShellCommand returns null", output);
        return SimplePerfStatResultParser.parseRawOutput(output);
    }

    public void executeCommand(String command, IShellOutputReceiver receiver) throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand(this.commandStringPreparer(command), receiver);
    }

    public void executeCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputShellResponse, TimeUnit timeUnit, int retryAttempts) throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand(this.commandStringPreparer(command), receiver, maxTimeToOutputShellResponse, timeUnit, retryAttempts);
    }

    protected String commandStringPreparer(String command) {
        if (command == null) {
            command = "";
        }
        return this.commandPrependPreparer().toString() + command;
    }

    private StringBuilder commandPrependPreparer() {
        if (this.mCachedCommandPrepend == null) {
            StringBuilder sb = new StringBuilder("simpleperf ");
            sb.append(this.mType.toString()).append(" ");
            if (this.mArguList != null) {
                for (String argu : this.mArguList) {
                    sb.append(argu).append(" ");
                }
            }
            this.mCachedCommandPrepend = sb;
        }
        return this.mCachedCommandPrepend;
    }

    public static enum SimplePerfType {
        STAT("stat"),
        REPORT("report"),
        RECORD("record"),
        LIST("list");

        private final String text;

        private SimplePerfType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

