/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SimpleStats {
    private List<Double> mData = new LinkedList<Double>();
    private double mSum = 0.0;

    public void addAll(Collection<? extends Double> c) {
        for (Double d : c) {
            if (d == null) {
                throw new NullPointerException();
            }
            this.add(d);
        }
    }

    public void add(double meas) {
        this.mData.add(meas);
        this.mSum += meas;
    }

    public List<Double> getData() {
        return this.mData;
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public int size() {
        return this.mData.size();
    }

    public Double mean() {
        if (this.isEmpty()) {
            return null;
        }
        return this.mSum / (double)this.size();
    }

    public Double median() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        if ((this.mData.size() & 1) == 1) {
            int idx = this.size() / 2;
            return this.mData.get(idx);
        }
        int idx = this.size() / 2;
        return (this.mData.get(idx - 1) + this.mData.get(idx)) / 2.0;
    }

    public Double min() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        return this.mData.get(0);
    }

    public Double max() {
        if (this.isEmpty()) {
            return null;
        }
        Collections.sort(this.mData);
        return this.mData.get(this.size() - 1);
    }

    public Double stdev() {
        if (this.isEmpty()) {
            return null;
        }
        Double avg = this.mean();
        double ssd = 0.0;
        for (Double meas : this.mData) {
            double diff = meas - avg;
            ssd += diff * diff;
        }
        return Math.sqrt(ssd / (double)this.size());
    }

    public Double meanOverOneStandardDeviationRange() {
        if (this.isEmpty()) {
            return null;
        }
        Double avg = this.mean();
        Double std = this.stdev();
        double upper = avg + std;
        double lower = avg - std;
        double sum = 0.0;
        int count = 0;
        for (Double meas : this.mData) {
            if (!(meas > lower) || !(meas < upper)) continue;
            sum += meas.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }
}

