/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;

public class SizeLimitedOutputStream
extends OutputStream {
    private static final int DEFAULT_NUM_TMP_FILES = 5;
    private static final int BUFF_SIZE = 32768;
    private final File[] mFiles;
    private final long mMaxFileSize;
    private CountingOutputStream mCurrentOutputStream;
    private int mCurrentFilePos = 0;
    private final String mTempFilePrefix;
    private final String mTempFileSuffix;

    public SizeLimitedOutputStream(long maxDataSize, int numFiles, String tempFilePrefix, String tempFileSuffix) {
        this.mMaxFileSize = maxDataSize / (long)numFiles;
        this.mFiles = new File[numFiles];
        this.mCurrentFilePos = numFiles;
        this.mTempFilePrefix = tempFilePrefix;
        this.mTempFileSuffix = tempFileSuffix;
    }

    public SizeLimitedOutputStream(long maxDataSize, String tempFilePrefix, String tempFileSuffix) {
        this(maxDataSize, 5, tempFilePrefix, tempFileSuffix);
    }

    public synchronized InputStream getData() throws IOException {
        this.flush();
        InputStream combinedStream = null;
        for (int i = 0; i < this.mFiles.length; ++i) {
            int currentPos = (this.mCurrentFilePos + i + 1) % this.mFiles.length;
            if (this.mFiles[currentPos] == null) continue;
            FileInputStream fStream = new FileInputStream(this.mFiles[currentPos]);
            combinedStream = combinedStream == null ? fStream : new SequenceInputStream(combinedStream, fStream);
        }
        if (combinedStream == null) {
            combinedStream = new ByteArrayInputStream(new byte[0]);
        }
        return combinedStream;
    }

    @Override
    public synchronized void flush() {
        if (this.mCurrentOutputStream == null) {
            return;
        }
        try {
            this.mCurrentOutputStream.flush();
        }
        catch (IOException e) {
            System.out.printf("failed to flush data: %s\n", e);
        }
    }

    public void delete() {
        this.close();
        for (int i = 0; i < this.mFiles.length; ++i) {
            FileUtil.deleteFile(this.mFiles[i]);
            this.mFiles[i] = null;
        }
    }

    @Override
    public synchronized void close() {
        StreamUtil.flushAndCloseStream(this.mCurrentOutputStream);
        this.mCurrentOutputStream = null;
    }

    synchronized void generateNextFile() throws IOException, FileNotFoundException {
        this.close();
        this.mCurrentFilePos = this.getNextIndex(this.mCurrentFilePos);
        FileUtil.deleteFile(this.mFiles[this.mCurrentFilePos]);
        this.mFiles[this.mCurrentFilePos] = FileUtil.createTempFile(this.mTempFilePrefix, this.mTempFileSuffix);
        this.mCurrentOutputStream = new CountingOutputStream(new BufferedOutputStream(new FileOutputStream(this.mFiles[this.mCurrentFilePos]), 32768));
    }

    private int getNextIndex(int i) {
        return (i + 1) % this.mFiles.length;
    }

    @Override
    public synchronized void write(int data) throws IOException {
        if (this.mCurrentOutputStream == null) {
            this.generateNextFile();
        }
        this.mCurrentOutputStream.write(data);
        if (this.mCurrentOutputStream.getCount() >= this.mMaxFileSize) {
            this.generateNextFile();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.mCurrentOutputStream == null) {
            this.generateNextFile();
        }
        while (len > 0) {
            long currentSize = this.mCurrentOutputStream.getCount();
            long freeSpace = this.mMaxFileSize - currentSize;
            long sizeToWrite = freeSpace > (long)len ? (long)len : freeSpace;
            this.mCurrentOutputStream.write(b, off, (int)sizeToWrite);
            off = (int)((long)off + sizeToWrite);
            len = (int)((long)len - sizeToWrite);
            if ((freeSpace -= sizeToWrite) > 0L) continue;
            this.generateNextFile();
        }
    }
}

