/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SparseImageUtil {
    private static final int SPARSE_IMAGE_MAGIC = -316211398;

    public static boolean isSparse(File imgFile) {
        boolean bl;
        if (!imgFile.isFile()) {
            return false;
        }
        FileInputStream in = new FileInputStream(imgFile);
        try {
            bl = SparseImageUtil.readBuffer(in, 4).getInt() == -316211398;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        in.close();
        return bl;
    }

    public static void unsparse(File imgFile, File destFile) throws IOException {
        try (FileInputStream in = new FileInputStream(imgFile);){
            SparseInputStream sis = new SparseInputStream(new BufferedInputStream(in), imgFile.length());
            if (!sis.isSparse()) {
                throw new IOException("Not a sparse image: " + imgFile);
            }
            FileUtil.writeToFile(sis, destFile);
        }
    }

    private static byte[] readFully(InputStream in, int size) throws IOException {
        byte[] buf = new byte[size];
        int n = 0;
        int off = 0;
        for (int left = size; left > 0; left -= n) {
            n = in.read(buf, off, left);
            if (n < 0) {
                throw new IOException("Unexpected EOF in readFully()");
            }
            off += n;
        }
        return buf;
    }

    private static ByteBuffer readBuffer(InputStream in, int size) throws IOException {
        return ByteBuffer.wrap(SparseImageUtil.readFully(in, size)).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static class SparseInputStream
    extends InputStream {
        private static final int FILE_HDR_SIZE = 28;
        private static final int CHUNK_HDR_SIZE = 12;
        private BufferedInputStream mIn;
        private boolean mIsSparse;
        private long mOriginalSize;
        private long mBlockSize;
        private long mTotalBlocks;
        private long mTotalChunks;
        private SparseChunk mCur;
        private long mLeft;
        private int mCurChunks;

        public SparseInputStream(BufferedInputStream in, long originalSize) throws IOException {
            this.mIn = in;
            this.mOriginalSize = originalSize;
            in.mark(56);
            ByteBuffer buf = null;
            try {
                buf = SparseImageUtil.readBuffer(this.mIn, 28);
                this.mIsSparse = buf.getInt() == -316211398;
            }
            catch (IOException e) {
                this.mIsSparse = false;
            }
            if (!this.mIsSparse) {
                this.mIn.reset();
                return;
            }
            short major = buf.getShort();
            short minor = buf.getShort();
            if (major > 1 || minor > 0) {
                throw new IOException("Unsupported sparse version: " + major + "." + minor);
            }
            if (buf.getShort() != 28) {
                throw new IOException("Illegal file header size");
            }
            if (buf.getShort() != 12) {
                throw new IOException("Illegal chunk header size");
            }
            this.mBlockSize = buf.getInt();
            if ((this.mBlockSize & 3L) != 0L) {
                throw new IOException("Illegal block size, must be a multiple of 4: " + this.mBlockSize);
            }
            this.mTotalBlocks = buf.getInt();
            this.mTotalChunks = buf.getInt();
            this.mLeft = 0L;
            this.mCurChunks = 0;
        }

        private boolean prepareChunk() throws IOException {
            if (this.mCur == null || this.mLeft <= 0L) {
                if ((long)(++this.mCurChunks) > this.mTotalChunks) {
                    return true;
                }
                this.mCur = SparseChunk.readChunk(this.mIn);
                this.mLeft = (long)this.mCur.mChunkSize * this.mBlockSize;
            }
            return this.mLeft == 0L;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (!this.mIsSparse) {
                return this.mIn.read(buf, off, len);
            }
            if (this.prepareChunk()) {
                return -1;
            }
            int n = -1;
            switch (this.mCur.mChunkType) {
                case -13631: {
                    n = this.mIn.read(buf, off, (int)Math.min(this.mLeft, (long)len));
                    this.mLeft -= (long)n;
                    break;
                }
                case -13629: {
                    n = (int)Math.min(this.mLeft, (long)len);
                    Arrays.fill(buf, off, off + n, (byte)0);
                    this.mLeft -= (long)n;
                    break;
                }
                case -13630: {
                    n = super.read(buf, off, len);
                    break;
                }
                default: {
                    throw new IOException("Unsupported Chunk:" + this.mCur);
                }
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            if (!this.mIsSparse) {
                return this.mIn.read();
            }
            if (this.prepareChunk()) {
                return -1;
            }
            int ret = -1;
            switch (this.mCur.mChunkType) {
                case -13631: {
                    ret = this.mIn.read();
                    break;
                }
                case -13629: {
                    ret = 0;
                    break;
                }
                case -13630: {
                    ret = Byte.toUnsignedInt(this.mCur.mFill[4 - ((int)this.mLeft & 3) & 3]);
                    break;
                }
                default: {
                    throw new IOException("Unsupported Chunk:" + this.mCur);
                }
            }
            --this.mLeft;
            return ret;
        }

        @Override
        public void close() throws IOException {
            StreamUtil.close(this.mIn);
        }

        public long size() {
            if (!this.mIsSparse) {
                return this.mOriginalSize;
            }
            return this.mBlockSize * this.mTotalBlocks;
        }

        public boolean isSparse() {
            return this.mIsSparse;
        }

        private static class SparseChunk {
            public static final short RAW = -13631;
            public static final short FILL = -13630;
            public static final short DONTCARE = -13629;
            public short mChunkType;
            public int mChunkSize;
            public int mTotalSize;
            public byte[] mFill;

            private SparseChunk() {
            }

            public String toString() {
                return String.format("type: %x, chunk_size: %d, total_size: %d", this.mChunkType, this.mChunkSize, this.mTotalSize);
            }

            public static SparseChunk readChunk(InputStream in) throws IOException {
                SparseChunk chunk = new SparseChunk();
                ByteBuffer buf = SparseImageUtil.readBuffer(in, 12);
                chunk.mChunkType = buf.getShort();
                buf.getShort();
                chunk.mChunkSize = buf.getInt();
                chunk.mTotalSize = buf.getInt();
                if (chunk.mChunkType == -13630) {
                    chunk.mFill = SparseImageUtil.readFully(in, 4);
                }
                return chunk;
            }
        }
    }
}

