/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.ByteArrayList;
import com.android.tradefed.util.FileUtil;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class StreamUtil {
    private static final int BUF_SIZE = 16384;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private StreamUtil() {
    }

    public static String getStringFromSource(InputStreamSource source) throws IOException {
        String contents;
        InputStream stream = source.createInputStream();
        try {
            contents = StreamUtil.getStringFromStream(stream);
        }
        finally {
            StreamUtil.close(stream);
        }
        return contents;
    }

    public static int countLinesFromSource(InputStreamSource source) throws IOException {
        int lineCount = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(source.createInputStream()));){
            while (br.readLine() != null) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    public static ByteArrayList getByteArrayListFromSource(InputStreamSource source) throws IOException {
        ByteArrayList contents;
        InputStream stream = source.createInputStream();
        try {
            contents = StreamUtil.getByteArrayListFromStream(stream);
        }
        finally {
            StreamUtil.close(stream);
        }
        return contents;
    }

    public static String getStringFromStream(InputStream stream) throws IOException {
        return StreamUtil.getStringFromStream(stream, 0L);
    }

    public static String getStringFromStream(InputStream stream, long length) throws IOException {
        int irChar = -1;
        StringBuilder builder = new StringBuilder();
        try (BufferedReader ir = new BufferedReader(new InputStreamReader(stream));){
            long count = 0L;
            while ((irChar = ((Reader)ir).read()) != -1) {
                builder.append((char)irChar);
                if (length <= 0L || ++count < length) continue;
                break;
            }
        }
        return builder.toString();
    }

    public static ByteArrayList getByteArrayListFromStream(InputStream stream) throws IOException {
        BufferedInputStream is = new BufferedInputStream(stream);
        int inputByte = -1;
        ByteArrayList list2 = new ByteArrayList();
        while ((inputByte = ((InputStream)is).read()) != -1) {
            list2.add((byte)inputByte);
        }
        list2.trimToSize();
        return list2;
    }

    public static BufferedReader getBufferedReaderFromStreamSrc(InputStreamSource stream) {
        return new BufferedReader(new InputStreamReader(stream.createInputStream()));
    }

    public static void copyStreams(InputStream inStream, OutputStream outStream) throws IOException {
        StreamUtil.copyStreams(inStream, outStream, 0);
    }

    public static void copyStreams(InputStream inStream, OutputStream outStream, int offset) throws IOException {
        StreamUtil.copyStreams(inStream, outStream, offset, -1L);
    }

    public static void copyStreams(InputStream inStream, OutputStream outStream, long offset, long size) throws IOException {
        Preconditions.checkArgument(offset >= 0L, "offset must be greater or equal to zero.");
        Preconditions.checkArgument(size != 0L, "size cannot be zero.");
        inStream.skip(offset);
        byte[] buf = new byte[16384];
        long totalRetrievedSize = 0L;
        try {
            int maxReadSize;
            int retrievedSize;
            while ((retrievedSize = inStream.read(buf, 0, maxReadSize = size > 0L ? (int)Math.min(size - totalRetrievedSize, (long)buf.length) : buf.length)) != -1) {
                outStream.write(buf, 0, retrievedSize);
                if (size != (totalRetrievedSize += (long)retrievedSize)) continue;
                break;
            }
        }
        catch (IOException e) {
            throw FileUtil.convertToDiskSpaceIfNeeded(e);
        }
        if (size > 0L && size > totalRetrievedSize) {
            throw new IOException(String.format("Failed to read %d bytes starting at offset %d, only %d bytes retrieved.", size, offset, totalRetrievedSize));
        }
    }

    public static void copyStreamToWriter(InputStream inStream, Writer writer) throws IOException {
        byte[] buf = new byte[16384];
        int size = -1;
        while ((size = inStream.read(buf)) != -1) {
            writer.write(new String(buf, 0, size));
        }
    }

    public static void copyFileToStream(File file2, OutputStream outStream) throws IOException {
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(file2);
            inStream = new BufferedInputStream(inStream);
            StreamUtil.copyStreams(inStream, outStream);
        }
        catch (Throwable throwable) {
            StreamUtil.close(inStream);
            throw throwable;
        }
        StreamUtil.close(inStream);
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream bytePrintStream = new PrintStream(outputStream);
        throwable.printStackTrace(bytePrintStream);
        return outputStream.toString();
    }

    @Deprecated
    public static void closeStream(OutputStream out) {
        StreamUtil.close(out);
    }

    @Deprecated
    public static void closeStream(InputStream in) {
        StreamUtil.close(in);
    }

    public static void flushAndCloseStream(OutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeZipStream(ZipOutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.closeEntry();
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeGZipStream(GZIPOutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.finish();
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void cancel(InputStreamSource outputSource) {
        if (outputSource != null) {
            outputSource.close();
        }
    }

    public static OutputStream nullOutputStream() {
        return ByteStreams.nullOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateCrc32(InputStream inStream) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] buf = new byte[16384];
        int size = -1;
        try {
            while ((size = inStream.read(buf)) >= 0) {
                crc32.update(buf, 0, size);
            }
        }
        finally {
            inStream.close();
        }
        return crc32.getValue();
    }

    public static String calculateMd5(InputStream inputSource) throws IOException {
        return StreamUtil.bytesToHexString(StreamUtil.calculateMd5Digest(inputSource));
    }

    public static String calculateBase64Md5(InputStream inputSource) throws IOException {
        return Base64.getEncoder().encodeToString(StreamUtil.calculateMd5Digest(inputSource));
    }

    private static byte[] calculateMd5Digest(InputStream inputSource) throws IOException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        BufferedInputStream input = new BufferedInputStream(new DigestInputStream(inputSource, md));
        byte[] buf = new byte[16384];
        while (((InputStream)input).read(buf) != -1) {
        }
        ((InputStream)input).close();
        return md.digest();
    }

    private static String bytesToHexString(byte[] bytes) {
        Objects.requireNonNull(bytes);
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0xF & bytes[i] >> 4;
            sb.append(HEX_CHARS[b]);
            b = 0xF & bytes[i];
            sb.append(HEX_CHARS[b]);
        }
        return sb.toString();
    }
}

