/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.QuotationAwareTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringEscapeUtils {
    public static String escapeShell(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '$': {
                    out.append("\\$");
                    continue block7;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                case '>': {
                    out.append("\\>");
                    continue block7;
                }
                case '<': {
                    out.append("\\<");
                    continue block7;
                }
                case '|': {
                    out.append("\\|");
                    continue block7;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    public static List<String> paramsToArgs(List<String> params) {
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] args = QuotationAwareTokenizer.tokenizeLine(param = param.replaceAll("\\\\(.)", "$1"), false);
            if (args.length == 0) continue;
            result.addAll(Arrays.asList(args));
        }
        return result;
    }
}

