/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ActionInProgress;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.SerializationUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;

public class SubprocessEventHelper {
    private static final String CLASSNAME_KEY = "className";
    private static final String TESTNAME_KEY = "testName";
    private static final String TRACE_KEY = "trace";
    private static final String CAUSE_KEY = "cause";
    private static final String RUNNAME_KEY = "runName";
    private static final String TESTCOUNT_KEY = "testCount";
    private static final String ATTEMPT_KEY = "runAttempt";
    private static final String TIME_KEY = "time";
    private static final String REASON_KEY = "reason";
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";
    private static final String DATA_NAME_KEY = "dataName";
    private static final String DATA_TYPE_KEY = "dataType";
    private static final String DATA_FILE_KEY = "dataFile";
    private static final String LOGGED_FILE_KEY = "loggedFile";
    private static final String TEST_TAG_KEY = "testTag";
    private static final String MODULE_CONTEXT_KEY = "moduleContextFileName";
    private static final String MODULE_NAME = "moduleName";
    private static final String FAILURE_STATUS_KEY = "failure_status";
    private static final String ACTION_IN_PROGRESS_KEY = "action_in_progress";
    private static final String ERROR_NAME_KEY = "error_name";
    private static final String ERROR_CODE_KEY = "error_code";
    private static final String ERROR_ORIGIN_KEY = "origin";

    private static void updateFailureFromJsonObject(final FailureDescription failure, JSONObject jsonObject) {
        failure.setOrigin(jsonObject.optString(ERROR_ORIGIN_KEY));
        TestRecordProto.FailureStatus status = TestRecordProto.FailureStatus.UNSET;
        if (!Strings.isNullOrEmpty(jsonObject.optString(FAILURE_STATUS_KEY))) {
            try {
                status = TestRecordProto.FailureStatus.valueOf(jsonObject.optString(FAILURE_STATUS_KEY));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LogUtil.CLog.e(e);
            }
        }
        failure.setFailureStatus(status);
        ActionInProgress action = ActionInProgress.UNSET;
        if (!Strings.isNullOrEmpty(jsonObject.optString(ACTION_IN_PROGRESS_KEY))) {
            try {
                action = ActionInProgress.valueOf(jsonObject.optString(ACTION_IN_PROGRESS_KEY));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LogUtil.CLog.e(e);
            }
        }
        failure.setActionInProgress(action);
        final String errorName = jsonObject.optString(ERROR_NAME_KEY);
        final long errorCode = jsonObject.optLong(ERROR_CODE_KEY);
        if (errorName != null) {
            ErrorIdentifier errorId = new ErrorIdentifier(){

                @Override
                public String name() {
                    return errorName;
                }

                @Override
                public long code() {
                    return errorCode;
                }

                @Override
                @Nonnull
                public TestRecordProto.FailureStatus status() {
                    TestRecordProto.FailureStatus status = failure.getFailureStatus();
                    return status == null ? TestRecordProto.FailureStatus.UNSET : status;
                }
            };
            failure.setErrorIdentifier(errorId);
        }
    }

    public static class TestModuleStartedEventInfo {
        public IInvocationContext mModuleContext;

        public TestModuleStartedEventInfo(IInvocationContext moduleContext) {
            this.mModuleContext = moduleContext;
        }

        public TestModuleStartedEventInfo(JSONObject jsonObject) throws JSONException {
            String file2 = jsonObject.getString(SubprocessEventHelper.MODULE_CONTEXT_KEY);
            try {
                this.mModuleContext = (IInvocationContext)SerializationUtil.deserialize(new File(file2), true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = new JSONObject();
                File serializedContext = SerializationUtil.serialize(this.mModuleContext);
                tags.put(SubprocessEventHelper.MODULE_CONTEXT_KEY, serializedContext.getAbsolutePath());
                String moduleName = this.mModuleContext.getAttributes().getUniqueMap().get("module-id");
                if (moduleName != null) {
                    tags.put(SubprocessEventHelper.MODULE_NAME, moduleName);
                }
            }
            catch (IOException | JSONException e) {
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
            return tags.toString();
        }
    }

    public static class InvocationEndedEventInfo {
        public Map<String, String> mBuildAttributes;

        public InvocationEndedEventInfo(Map<String, String> buildAttributes) {
            this.mBuildAttributes = new HashMap<String, String>(buildAttributes);
        }

        public InvocationEndedEventInfo(JSONObject jsonObject) throws JSONException {
            this.mBuildAttributes = new HashMap<String, String>();
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.mBuildAttributes.put(key, jsonObject.get(key).toString());
            }
        }

        public String toString() {
            JSONObject jsonObject = new JSONObject(this.mBuildAttributes);
            return jsonObject.toString();
        }
    }

    public static class InvocationStartedEventInfo {
        public String mTestTag = null;
        public Long mStartTime = null;

        public InvocationStartedEventInfo(String testTag, Long startTime) {
            this.mTestTag = testTag;
            this.mStartTime = startTime;
        }

        public InvocationStartedEventInfo(JSONObject jsonObject) throws JSONException {
            this.mTestTag = jsonObject.getString(SubprocessEventHelper.TEST_TAG_KEY);
            if (jsonObject.has(SubprocessEventHelper.START_TIME)) {
                this.mStartTime = jsonObject.getLong(SubprocessEventHelper.START_TIME);
            }
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = new JSONObject();
                if (this.mTestTag != null) {
                    tags.put(SubprocessEventHelper.TEST_TAG_KEY, this.mTestTag);
                }
                if (this.mStartTime != null) {
                    tags.put(SubprocessEventHelper.START_TIME, this.mStartTime);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class LogAssociationEventInfo {
        public String mDataName = null;
        public LogFile mLoggedFile = null;

        public LogAssociationEventInfo(String dataName, LogFile loggedFile) {
            this.mDataName = dataName;
            this.mLoggedFile = loggedFile;
        }

        public LogAssociationEventInfo(JSONObject jsonObject) throws JSONException {
            this.mDataName = jsonObject.getString(SubprocessEventHelper.DATA_NAME_KEY);
            jsonObject.remove(SubprocessEventHelper.DATA_NAME_KEY);
            String file2 = jsonObject.getString(SubprocessEventHelper.LOGGED_FILE_KEY);
            try {
                this.mLoggedFile = (LogFile)SerializationUtil.deserialize(new File(file2), true);
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage());
            }
            finally {
                FileUtil.deleteFile(new File(file2));
            }
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = new JSONObject();
                if (this.mDataName != null) {
                    tags.put(SubprocessEventHelper.DATA_NAME_KEY, this.mDataName);
                }
                if (this.mLoggedFile != null) {
                    File serializedLoggedFile = SerializationUtil.serialize(this.mLoggedFile);
                    tags.put(SubprocessEventHelper.LOGGED_FILE_KEY, serializedLoggedFile.getAbsolutePath());
                }
            }
            catch (IOException | JSONException e) {
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
            return tags.toString();
        }
    }

    public static class TestLogEventInfo {
        public String mDataName = null;
        public LogDataType mLogType = null;
        public File mDataFile = null;

        public TestLogEventInfo(String dataName, LogDataType dataType, File dataFile) {
            this.mDataName = dataName;
            this.mLogType = dataType;
            this.mDataFile = dataFile;
        }

        public TestLogEventInfo(JSONObject jsonObject) throws JSONException {
            this.mDataName = jsonObject.getString(SubprocessEventHelper.DATA_NAME_KEY);
            jsonObject.remove(SubprocessEventHelper.DATA_NAME_KEY);
            try {
                this.mLogType = LogDataType.valueOf(jsonObject.getString(SubprocessEventHelper.DATA_TYPE_KEY));
            }
            catch (IllegalArgumentException e) {
                LogUtil.CLog.e("Failed to parse type: %s", jsonObject.getString(SubprocessEventHelper.DATA_TYPE_KEY));
                this.mLogType = LogDataType.TEXT;
            }
            jsonObject.remove(SubprocessEventHelper.DATA_TYPE_KEY);
            this.mDataFile = new File(jsonObject.getString(SubprocessEventHelper.DATA_FILE_KEY));
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = new JSONObject();
                if (this.mDataName != null) {
                    tags.put(SubprocessEventHelper.DATA_NAME_KEY, this.mDataName);
                }
                if (this.mLogType != null) {
                    tags.put(SubprocessEventHelper.DATA_TYPE_KEY, this.mLogType.toString());
                }
                if (this.mDataFile != null) {
                    tags.put(SubprocessEventHelper.DATA_FILE_KEY, this.mDataFile.getAbsolutePath());
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class TestEndedEventInfo
    extends BaseTestEventInfo {
        public Map<String, String> mRunMetrics = null;
        public Long mEndTime = null;

        public TestEndedEventInfo(String className, String testName, Map<String, String> runMetrics) {
            super(className, testName);
            this.mRunMetrics = runMetrics;
            this.mEndTime = System.currentTimeMillis();
        }

        public TestEndedEventInfo(String className, String testName, Long endTime, Map<String, String> runMetrics) {
            super(className, testName);
            this.mEndTime = endTime;
            this.mRunMetrics = runMetrics;
        }

        public TestEndedEventInfo(JSONObject jsonObject) throws JSONException {
            super(jsonObject);
            if (jsonObject.has(SubprocessEventHelper.END_TIME)) {
                this.mEndTime = jsonObject.getLong(SubprocessEventHelper.END_TIME);
            }
            jsonObject.remove(SubprocessEventHelper.END_TIME);
            Iterator i = jsonObject.keys();
            this.mRunMetrics = new HashMap<String, String>();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.mRunMetrics.put(key, jsonObject.get(key).toString());
            }
        }

        @Override
        protected JSONObject getNewJson() {
            JSONObject json = this.mRunMetrics != null ? new JSONObject(this.mRunMetrics) : new JSONObject();
            try {
                json.put(SubprocessEventHelper.END_TIME, this.mEndTime);
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return json;
        }
    }

    public static class FailedTestEventInfo
    extends BaseTestEventInfo {
        public String mTrace = null;
        public FailureDescription mFailure = null;

        public FailedTestEventInfo(String className, String testName, String trace) {
            super(className, testName);
            this.mTrace = trace;
        }

        public FailedTestEventInfo(String className, String testName, FailureDescription failure) {
            super(className, testName);
            this.mFailure = failure;
        }

        public FailedTestEventInfo(JSONObject jsonObject) throws JSONException {
            super(jsonObject);
            this.mTrace = jsonObject.getString(SubprocessEventHelper.TRACE_KEY);
            this.mFailure = FailureDescription.create(this.mTrace);
            SubprocessEventHelper.updateFailureFromJsonObject(this.mFailure, jsonObject);
        }

        @Override
        public String toString() {
            JSONObject tags = null;
            try {
                tags = new JSONObject(super.toString());
                if (this.mFailure != null) {
                    tags.put(SubprocessEventHelper.TRACE_KEY, this.mFailure.getErrorMessage());
                    tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getFailureStatus());
                    tags.putOpt(SubprocessEventHelper.ACTION_IN_PROGRESS_KEY, (Object)this.mFailure.getActionInProgress());
                    tags.putOpt(SubprocessEventHelper.ERROR_ORIGIN_KEY, this.mFailure.getOrigin());
                    if (this.mFailure.getErrorIdentifier() != null) {
                        tags.putOpt(SubprocessEventHelper.ERROR_NAME_KEY, this.mFailure.getErrorIdentifier().name());
                        tags.putOpt(SubprocessEventHelper.ERROR_CODE_KEY, this.mFailure.getErrorIdentifier().code());
                        tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getErrorIdentifier().status());
                    }
                }
                if (this.mTrace != null) {
                    tags.put(SubprocessEventHelper.TRACE_KEY, this.mTrace);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class TestStartedEventInfo
    extends BaseTestEventInfo {
        public Long mStartTime = null;

        public TestStartedEventInfo(String className, String testName, Long startTime) {
            super(className, testName);
            this.mStartTime = startTime;
        }

        public TestStartedEventInfo(JSONObject jsonObject) throws JSONException {
            super(jsonObject);
            if (jsonObject.has(SubprocessEventHelper.START_TIME)) {
                this.mStartTime = jsonObject.getLong(SubprocessEventHelper.START_TIME);
            }
            jsonObject.remove(SubprocessEventHelper.START_TIME);
        }

        @Override
        protected JSONObject getNewJson() {
            JSONObject json = new JSONObject();
            try {
                json.put(SubprocessEventHelper.START_TIME, this.mStartTime);
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return json;
        }
    }

    public static class BaseTestEventInfo {
        public String mClassName = null;
        public String mTestName = null;

        public BaseTestEventInfo(String className, String testName) {
            this.mClassName = className;
            this.mTestName = testName;
        }

        public BaseTestEventInfo(JSONObject jsonObject) throws JSONException {
            this.mClassName = jsonObject.getString(SubprocessEventHelper.CLASSNAME_KEY);
            jsonObject.remove(SubprocessEventHelper.CLASSNAME_KEY);
            this.mTestName = jsonObject.getString(SubprocessEventHelper.TESTNAME_KEY);
            jsonObject.remove(SubprocessEventHelper.TESTNAME_KEY);
        }

        protected JSONObject getNewJson() {
            return new JSONObject();
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = this.getNewJson();
                if (this.mClassName != null) {
                    tags.put(SubprocessEventHelper.CLASSNAME_KEY, this.mClassName);
                }
                if (this.mTestName != null) {
                    tags.put(SubprocessEventHelper.TESTNAME_KEY, this.mTestName);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class InvocationFailedEventInfo {
        public Throwable mCause = null;
        public FailureDescription mFailure = null;

        public InvocationFailedEventInfo(Throwable cause) {
            this.mCause = cause;
        }

        public InvocationFailedEventInfo(FailureDescription failure) {
            this.mCause = failure.getCause() != null ? failure.getCause() : new Throwable(failure.getErrorMessage());
            this.mFailure = failure;
        }

        public InvocationFailedEventInfo(JSONObject jsonObject) throws JSONException {
            String stack = jsonObject.getString(SubprocessEventHelper.CAUSE_KEY);
            this.mCause = new Throwable(stack);
            if (!Strings.isNullOrEmpty(jsonObject.optString(SubprocessEventHelper.REASON_KEY))) {
                this.mFailure = FailureDescription.create(jsonObject.optString(SubprocessEventHelper.REASON_KEY)).setOrigin(jsonObject.optString(SubprocessEventHelper.ERROR_ORIGIN_KEY)).setCause(this.mCause);
                TestRecordProto.FailureStatus status = TestRecordProto.FailureStatus.UNSET;
                if (!Strings.isNullOrEmpty(jsonObject.optString(SubprocessEventHelper.FAILURE_STATUS_KEY))) {
                    try {
                        status = TestRecordProto.FailureStatus.valueOf(jsonObject.optString(SubprocessEventHelper.FAILURE_STATUS_KEY));
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        LogUtil.CLog.e(e);
                    }
                }
                this.mFailure.setFailureStatus(status);
                ActionInProgress action = ActionInProgress.UNSET;
                if (!Strings.isNullOrEmpty(jsonObject.optString(SubprocessEventHelper.ACTION_IN_PROGRESS_KEY))) {
                    try {
                        action = ActionInProgress.valueOf(jsonObject.optString(SubprocessEventHelper.ACTION_IN_PROGRESS_KEY));
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        LogUtil.CLog.e(e);
                    }
                }
                this.mFailure.setActionInProgress(action);
                final String errorName = jsonObject.optString(SubprocessEventHelper.ERROR_NAME_KEY);
                final long errorCode = jsonObject.optLong(SubprocessEventHelper.ERROR_CODE_KEY);
                if (errorName != null) {
                    ErrorIdentifier errorId = new ErrorIdentifier(){

                        @Override
                        public String name() {
                            return errorName;
                        }

                        @Override
                        public long code() {
                            return errorCode;
                        }

                        @Override
                        @Nonnull
                        public TestRecordProto.FailureStatus status() {
                            TestRecordProto.FailureStatus status = mFailure.getFailureStatus();
                            return status == null ? TestRecordProto.FailureStatus.UNSET : status;
                        }
                    };
                    this.mFailure.setErrorIdentifier(errorId);
                }
            }
        }

        public String toString() {
            JSONObject tags = new JSONObject();
            try {
                if (this.mFailure != null) {
                    tags.put(SubprocessEventHelper.REASON_KEY, this.mFailure.getErrorMessage());
                    tags.putOpt(SubprocessEventHelper.ACTION_IN_PROGRESS_KEY, (Object)this.mFailure.getActionInProgress());
                    tags.putOpt(SubprocessEventHelper.ERROR_ORIGIN_KEY, this.mFailure.getOrigin());
                    if (this.mFailure.getErrorIdentifier() != null) {
                        tags.putOpt(SubprocessEventHelper.ERROR_NAME_KEY, this.mFailure.getErrorIdentifier().name());
                        tags.putOpt(SubprocessEventHelper.ERROR_CODE_KEY, this.mFailure.getErrorIdentifier().code());
                        tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getErrorIdentifier().status());
                    } else {
                        tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getFailureStatus());
                    }
                }
                if (this.mCause != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    this.mCause.printStackTrace(pw);
                    tags.put(SubprocessEventHelper.CAUSE_KEY, sw.toString());
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class TestRunEndedEventInfo {
        public Long mTime = null;
        public Map<String, String> mRunMetrics = null;

        public TestRunEndedEventInfo(Long time, Map<String, String> runMetrics) {
            this.mTime = time;
            this.mRunMetrics = runMetrics;
        }

        public TestRunEndedEventInfo(JSONObject jsonObject) throws JSONException {
            this.mTime = jsonObject.getLong(SubprocessEventHelper.TIME_KEY);
            jsonObject.remove(SubprocessEventHelper.TIME_KEY);
            Iterator i = jsonObject.keys();
            this.mRunMetrics = new HashMap<String, String>();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.mRunMetrics.put(key, jsonObject.get(key).toString());
            }
        }

        public String toString() {
            JSONObject tags = null;
            try {
                tags = this.mRunMetrics != null ? new JSONObject(this.mRunMetrics) : new JSONObject();
                if (this.mTime != null) {
                    tags.put(SubprocessEventHelper.TIME_KEY, this.mTime);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class TestRunFailedEventInfo {
        public String mReason = null;
        public FailureDescription mFailure = null;

        public TestRunFailedEventInfo(String reason) {
            this.mReason = reason;
        }

        public TestRunFailedEventInfo(FailureDescription failure) {
            this.mFailure = failure;
        }

        public TestRunFailedEventInfo(JSONObject jsonObject) throws JSONException {
            this.mReason = jsonObject.getString(SubprocessEventHelper.REASON_KEY);
            this.mFailure = FailureDescription.create(this.mReason);
            SubprocessEventHelper.updateFailureFromJsonObject(this.mFailure, jsonObject);
        }

        public String toString() {
            JSONObject tags = new JSONObject();
            try {
                if (this.mFailure != null) {
                    tags.put(SubprocessEventHelper.REASON_KEY, this.mFailure.getErrorMessage());
                    tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getFailureStatus());
                    tags.putOpt(SubprocessEventHelper.ACTION_IN_PROGRESS_KEY, (Object)this.mFailure.getActionInProgress());
                    tags.putOpt(SubprocessEventHelper.ERROR_ORIGIN_KEY, this.mFailure.getOrigin());
                    if (this.mFailure.getErrorIdentifier() != null) {
                        tags.putOpt(SubprocessEventHelper.ERROR_NAME_KEY, this.mFailure.getErrorIdentifier().name());
                        tags.putOpt(SubprocessEventHelper.ERROR_CODE_KEY, this.mFailure.getErrorIdentifier().code());
                        tags.putOpt(SubprocessEventHelper.FAILURE_STATUS_KEY, this.mFailure.getErrorIdentifier().status());
                    }
                }
                if (this.mReason != null) {
                    tags.put(SubprocessEventHelper.REASON_KEY, this.mReason);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }

    public static class TestRunStartedEventInfo {
        public String mRunName = null;
        public Integer mTestCount = null;
        public Integer mAttempt = null;
        public Long mStartTime = null;

        public TestRunStartedEventInfo(String runName, int testCount) {
            this.mRunName = runName;
            this.mTestCount = testCount;
            this.mAttempt = 0;
            this.mStartTime = System.currentTimeMillis();
        }

        public TestRunStartedEventInfo(String runName, int testCount, int attempt, long startTime) {
            this.mRunName = runName;
            this.mTestCount = testCount;
            this.mAttempt = attempt;
            this.mStartTime = startTime;
        }

        public TestRunStartedEventInfo(JSONObject jsonObject) throws JSONException {
            this.mRunName = jsonObject.getString(SubprocessEventHelper.RUNNAME_KEY);
            this.mTestCount = jsonObject.getInt(SubprocessEventHelper.TESTCOUNT_KEY);
            this.mAttempt = jsonObject.optInt(SubprocessEventHelper.ATTEMPT_KEY, 0);
            this.mStartTime = jsonObject.optLong(SubprocessEventHelper.START_TIME, System.currentTimeMillis());
        }

        public String toString() {
            JSONObject tags = new JSONObject();
            try {
                if (this.mRunName != null) {
                    tags.put(SubprocessEventHelper.RUNNAME_KEY, this.mRunName);
                }
                if (this.mTestCount != null) {
                    tags.put(SubprocessEventHelper.TESTCOUNT_KEY, this.mTestCount);
                }
                if (this.mAttempt != null) {
                    tags.put(SubprocessEventHelper.ATTEMPT_KEY, this.mAttempt);
                }
                if (this.mStartTime != null) {
                    tags.put(SubprocessEventHelper.START_TIME, this.mStartTime);
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
            return tags.toString();
        }
    }
}

