/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class SubprocessExceptionParser {
    public static final String EVENT_THREAD_JOIN = "Event receiver thread did not complete.";

    public static String getPathFromStderr(String stderr) {
        String patternString = String.format(".*%s.*", "serialized_exception");
        Pattern pattern = Pattern.compile(patternString);
        for (String line : stderr.split("\n")) {
            Matcher m = pattern.matcher(line);
            if (m.matches()) {
                try {
                    JSONObject json = new JSONObject(line);
                    String filePath = json.getString("serialized_exception");
                    return filePath;
                }
                catch (JSONException e) {
                    LogUtil.CLog.w("Could not parse the stderr as a particular exception.");
                    continue;
                }
            }
            LogUtil.CLog.w("'%s' doesn't match pattern '%s'", line, patternString);
        }
        return null;
    }

    public static void handleStderrException(CommandResult result) throws DeviceNotAvailableException {
        String stderr = result.getStderr();
        String filePath = SubprocessExceptionParser.getPathFromStderr(stderr);
        Integer exitCode = result.getExitCode();
        String message2 = String.format("Subprocess finished with error exit code: %s.\nStderr: %s", exitCode, stderr);
        if (filePath != null) {
            try {
                File exception = new File(filePath);
                Throwable obj = (Throwable)SerializationUtil.deserialize(exception, true);
                if (obj instanceof DeviceNotAvailableException) {
                    throw (DeviceNotAvailableException)obj;
                }
                if (obj instanceof IHarnessException) {
                    throw new HarnessRuntimeException(message2, (IHarnessException)((Object)obj));
                }
                throw new HarnessRuntimeException(message2, obj, InfraErrorIdentifier.UNDETERMINED);
            }
            catch (IOException e) {
                LogUtil.CLog.w("Could not parse the stderr as a particular exception. Using HarnessRuntimeException instead.");
            }
        }
        InfraErrorIdentifier id = InfraErrorIdentifier.UNDETERMINED;
        if (CommandStatus.TIMED_OUT.equals((Object)result.getStatus())) {
            id = InfraErrorIdentifier.INVOCATION_TIMEOUT;
        }
        if (stderr.startsWith(EVENT_THREAD_JOIN)) {
            id = InfraErrorIdentifier.EVENT_PROCESSING_TIMEOUT;
        }
        throw new HarnessRuntimeException(message2, id);
    }
}

