/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.tracing.TracingLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SubprocessEventHelper;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class SubprocessTestResultsParser
implements Closeable {
    private ITestInvocationListener mListener;
    private TestDescription mCurrentTestCase = null;
    private IInvocationContext mCurrentModuleContext = null;
    private String mCurrentRunName = null;
    private SubprocessEventHelper.InvocationFailedEventInfo mReportedInvocationFailedEventInfo = null;
    private Pattern mPattern = null;
    private Map<String, EventHandler> mHandlerMap = null;
    private EventReceiverThread mEventReceiver = null;
    private IInvocationContext mContext = null;
    private Long mStartTime = null;
    private boolean mIgnoreTestLog = true;
    private Set<String> mTestLogged = new HashSet<String>();

    public boolean joinReceiver(long millis) {
        return this.joinReceiver(millis, true);
    }

    public boolean joinReceiver(long millis, boolean waitForConnection) {
        if (this.mEventReceiver != null) {
            try {
                LogUtil.CLog.i("Waiting for events to finish being processed.");
                if (!this.mEventReceiver.await(millis, waitForConnection)) {
                    this.mEventReceiver.stopParsing();
                    LogUtil.CLog.e("Event receiver thread did not complete. Some events may be missing.");
                    return false;
                }
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public int getSocketServerPort() {
        if (this.mEventReceiver != null) {
            return this.mEventReceiver.getLocalPort();
        }
        return -1;
    }

    public void setIgnoreTestLog(boolean ignoreTestLog) {
        this.mIgnoreTestLog = ignoreTestLog;
    }

    @Override
    public void close() throws IOException {
        if (this.mEventReceiver != null) {
            this.mEventReceiver.cancel();
        }
    }

    public SubprocessTestResultsParser(ITestInvocationListener listener, boolean streaming, IInvocationContext context) throws IOException {
        this(listener, context);
        if (streaming) {
            this.mEventReceiver = new EventReceiverThread();
            this.mEventReceiver.start();
        }
    }

    public SubprocessTestResultsParser(ITestInvocationListener listener, IInvocationContext context) {
        this.mListener = listener;
        this.mContext = context;
        StringBuilder sb = new StringBuilder();
        sb.append("INVOCATION_FAILED").append("|");
        sb.append("TEST_ASSUMPTION_FAILURE").append("|");
        sb.append("TEST_ENDED").append("|");
        sb.append("TEST_FAILED").append("|");
        sb.append("TEST_IGNORED").append("|");
        sb.append("TEST_STARTED").append("|");
        sb.append("TEST_RUN_ENDED").append("|");
        sb.append("TEST_RUN_FAILED").append("|");
        sb.append("TEST_RUN_STARTED").append("|");
        sb.append("TEST_MODULE_STARTED").append("|");
        sb.append("TEST_MODULE_ENDED").append("|");
        sb.append("TEST_LOG").append("|");
        sb.append("LOG_ASSOCIATION").append("|");
        sb.append("INVOCATION_STARTED").append("|");
        sb.append("INVOCATION_ENDED");
        String patt = String.format("(.*)(%s)( )(.*)", sb.toString());
        this.mPattern = Pattern.compile(patt);
        this.mHandlerMap = new HashMap<String, EventHandler>();
        this.mHandlerMap.put("INVOCATION_FAILED", new InvocationFailedEventHandler());
        this.mHandlerMap.put("TEST_ASSUMPTION_FAILURE", new TestAssumptionFailureEventHandler());
        this.mHandlerMap.put("TEST_ENDED", new TestEndedEventHandler());
        this.mHandlerMap.put("TEST_FAILED", new TestFailedEventHandler());
        this.mHandlerMap.put("TEST_IGNORED", new TestIgnoredEventHandler());
        this.mHandlerMap.put("TEST_STARTED", new TestStartedEventHandler());
        this.mHandlerMap.put("TEST_RUN_ENDED", new TestRunEndedEventHandler());
        this.mHandlerMap.put("TEST_RUN_FAILED", new TestRunFailedEventHandler());
        this.mHandlerMap.put("TEST_RUN_STARTED", new TestRunStartedEventHandler());
        this.mHandlerMap.put("TEST_MODULE_STARTED", new TestModuleStartedEventHandler());
        this.mHandlerMap.put("TEST_MODULE_ENDED", new TestModuleEndedEventHandler());
        this.mHandlerMap.put("TEST_LOG", new TestLogEventHandler());
        this.mHandlerMap.put("LOG_ASSOCIATION", new LogAssociationEventHandler());
        this.mHandlerMap.put("INVOCATION_STARTED", new InvocationStartedEventHandler());
        this.mHandlerMap.put("INVOCATION_ENDED", new InvocationEndedEventHandler());
    }

    public void parseFile(File file2) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file2));
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e(e);
            throw new RuntimeException(e);
        }
        ArrayList<String> listString = new ArrayList<String>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                listString.add(line);
            }
            reader.close();
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            throw new RuntimeException(e);
        }
        this.processNewLines(listString.toArray(new String[listString.size()]));
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            try {
                this.parse(line);
            }
            catch (JSONException e) {
                LogUtil.CLog.e("Exception while parsing");
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
        }
    }

    private void parse(String line) throws JSONException {
        Matcher matcher = this.mPattern.matcher(line);
        if (matcher.find()) {
            EventHandler handler = this.mHandlerMap.get(matcher.group(2));
            if (handler != null) {
                handler.handleEvent(matcher.group(4));
            } else {
                LogUtil.CLog.w("No handler found matching: %s", matcher.group(2));
            }
        }
    }

    private void checkCurrentTestId(String className, String testName) {
        if (this.mCurrentTestCase == null) {
            this.mCurrentTestCase = new TestDescription(className, testName);
            LogUtil.CLog.w("Calling a test event without having called testStarted.");
        }
    }

    public Long getStartTime() {
        return this.mStartTime;
    }

    public TestDescription getCurrentTest() {
        return this.mCurrentTestCase;
    }

    public boolean reportedInvocationFailed() {
        return this.mReportedInvocationFailedEventInfo != null;
    }

    public SubprocessEventHelper.InvocationFailedEventInfo getReportedInvocationFailedEventInfo() {
        return this.mReportedInvocationFailedEventInfo;
    }

    public void completeModuleEvents() {
        FailureDescription failure;
        if (this.mCurrentRunName == null && this.mCurrentModuleContext != null) {
            String moduleId = this.mCurrentModuleContext.getAttributes().getUniqueMap().get("module-id");
            this.mListener.testRunStarted(moduleId, 0);
        }
        if (this.mCurrentTestCase != null) {
            failure = FailureDescription.create("Run was interrupted after starting, results are incomplete.");
            this.mListener.testFailed(this.mCurrentTestCase, failure);
            this.mListener.testEnded(this.mCurrentTestCase, new HashMap<String, MetricMeasurement.Metric>());
        }
        if (this.mCurrentModuleContext != null || this.mCurrentRunName != null) {
            failure = FailureDescription.create("Run was interrupted after starting, results are incomplete.", TestRecordProto.FailureStatus.INFRA_FAILURE);
            this.mListener.testRunFailed(failure);
            this.mListener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            this.mCurrentRunName = null;
        }
        if (this.mCurrentModuleContext != null) {
            this.mListener.testModuleEnded();
        }
    }

    private class EventReceiverThread
    extends Thread {
        private ServerSocket mSocket;
        private Semaphore mSemaphore;
        private boolean mShouldParse;

        public EventReceiverThread() throws IOException {
            super("EventReceiverThread");
            this.mSemaphore = new Semaphore(1);
            this.mShouldParse = true;
            this.mSocket = new ServerSocket(0);
        }

        protected int getLocalPort() {
            return this.mSocket.getLocalPort();
        }

        boolean await(long millis, boolean waitForConnection) throws InterruptedException {
            int permits;
            int n = permits = waitForConnection ? 2 : 1;
            if (this.mSemaphore.tryAcquire(permits, millis, TimeUnit.MILLISECONDS)) {
                this.mSemaphore.release(permits);
                return true;
            }
            return false;
        }

        public void cancel() throws IOException {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }

        public void stopParsing() {
            this.mShouldParse = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket client = null;
            BufferedReader in = null;
            try {
                client = this.mSocket.accept();
                this.mSemaphore.acquire();
                in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                String event = null;
                while ((event = in.readLine()) != null) {
                    try {
                        if (this.mShouldParse) {
                            LogUtil.CLog.d("received event: '%s'", event);
                            SubprocessTestResultsParser.this.parse(event);
                            continue;
                        }
                        LogUtil.CLog.d("Skipping parsing of event: '%s'", event);
                    }
                    catch (JSONException e) {
                        LogUtil.CLog.e(e);
                    }
                }
                StreamUtil.close(in);
                this.mSemaphore.release(2);
            }
            catch (IOException | InterruptedException e) {
                LogUtil.CLog.e(e);
            }
            finally {
                StreamUtil.close(in);
                this.mSemaphore.release(2);
            }
            LogUtil.CLog.d("EventReceiverThread done.");
        }
    }

    public static class StatusKeys {
        public static final String INVOCATION_FAILED = "INVOCATION_FAILED";
        public static final String TEST_ASSUMPTION_FAILURE = "TEST_ASSUMPTION_FAILURE";
        public static final String TEST_ENDED = "TEST_ENDED";
        public static final String TEST_FAILED = "TEST_FAILED";
        public static final String TEST_IGNORED = "TEST_IGNORED";
        public static final String TEST_STARTED = "TEST_STARTED";
        public static final String TEST_RUN_ENDED = "TEST_RUN_ENDED";
        public static final String TEST_RUN_FAILED = "TEST_RUN_FAILED";
        public static final String TEST_RUN_STARTED = "TEST_RUN_STARTED";
        public static final String TEST_MODULE_STARTED = "TEST_MODULE_STARTED";
        public static final String TEST_MODULE_ENDED = "TEST_MODULE_ENDED";
        public static final String TEST_LOG = "TEST_LOG";
        public static final String LOG_ASSOCIATION = "LOG_ASSOCIATION";
        public static final String INVOCATION_STARTED = "INVOCATION_STARTED";
        public static final String INVOCATION_ENDED = "INVOCATION_ENDED";
    }

    private class InvocationFailedEventHandler
    implements EventHandler {
        private InvocationFailedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.InvocationFailedEventInfo ifi = new SubprocessEventHelper.InvocationFailedEventInfo(new JSONObject(eventJson));
            if (ifi.mFailure != null) {
                SubprocessTestResultsParser.this.mListener.invocationFailed(ifi.mFailure);
            } else {
                SubprocessTestResultsParser.this.mListener.invocationFailed(ifi.mCause);
            }
            SubprocessTestResultsParser.this.mReportedInvocationFailedEventInfo = ifi;
        }
    }

    private class TestAssumptionFailureEventHandler
    implements EventHandler {
        private TestAssumptionFailureEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.FailedTestEventInfo FailedAssumption = new SubprocessEventHelper.FailedTestEventInfo(new JSONObject(eventJson));
            SubprocessTestResultsParser.this.checkCurrentTestId(FailedAssumption.mClassName, FailedAssumption.mTestName);
            SubprocessTestResultsParser.this.mListener.testAssumptionFailure(SubprocessTestResultsParser.this.mCurrentTestCase, FailedAssumption.mTrace);
        }
    }

    private class TestEndedEventHandler
    implements EventHandler {
        private TestEndedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            try {
                SubprocessEventHelper.TestEndedEventInfo tei = new SubprocessEventHelper.TestEndedEventInfo(new JSONObject(eventJson));
                SubprocessTestResultsParser.this.checkCurrentTestId(tei.mClassName, tei.mTestName);
                if (tei.mEndTime != null) {
                    SubprocessTestResultsParser.this.mListener.testEnded(SubprocessTestResultsParser.this.mCurrentTestCase, (long)tei.mEndTime, TfMetricProtoUtil.upgradeConvert(tei.mRunMetrics));
                } else {
                    SubprocessTestResultsParser.this.mListener.testEnded(SubprocessTestResultsParser.this.mCurrentTestCase, TfMetricProtoUtil.upgradeConvert(tei.mRunMetrics));
                }
            }
            finally {
                SubprocessTestResultsParser.this.mCurrentTestCase = null;
            }
        }
    }

    private class TestFailedEventHandler
    implements EventHandler {
        private TestFailedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.FailedTestEventInfo fti = new SubprocessEventHelper.FailedTestEventInfo(new JSONObject(eventJson));
            SubprocessTestResultsParser.this.checkCurrentTestId(fti.mClassName, fti.mTestName);
            SubprocessTestResultsParser.this.mListener.testFailed(SubprocessTestResultsParser.this.mCurrentTestCase, fti.mFailure);
        }
    }

    private class TestIgnoredEventHandler
    implements EventHandler {
        private TestIgnoredEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.BaseTestEventInfo baseTestIgnored = new SubprocessEventHelper.BaseTestEventInfo(new JSONObject(eventJson));
            SubprocessTestResultsParser.this.checkCurrentTestId(baseTestIgnored.mClassName, baseTestIgnored.mTestName);
            SubprocessTestResultsParser.this.mListener.testIgnored(SubprocessTestResultsParser.this.mCurrentTestCase);
        }
    }

    private class TestStartedEventHandler
    implements EventHandler {
        private TestStartedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.TestStartedEventInfo bti = new SubprocessEventHelper.TestStartedEventInfo(new JSONObject(eventJson));
            SubprocessTestResultsParser.this.mCurrentTestCase = new TestDescription(bti.mClassName, bti.mTestName);
            if (bti.mStartTime != null) {
                SubprocessTestResultsParser.this.mListener.testStarted(SubprocessTestResultsParser.this.mCurrentTestCase, bti.mStartTime);
            } else {
                SubprocessTestResultsParser.this.mListener.testStarted(SubprocessTestResultsParser.this.mCurrentTestCase);
            }
        }
    }

    private class TestRunEndedEventHandler
    implements EventHandler {
        private TestRunEndedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            try {
                SubprocessEventHelper.TestRunEndedEventInfo rei = new SubprocessEventHelper.TestRunEndedEventInfo(new JSONObject(eventJson));
                SubprocessTestResultsParser.this.mListener.testRunEnded((long)rei.mTime, TfMetricProtoUtil.upgradeConvert(rei.mRunMetrics, true));
            }
            finally {
                SubprocessTestResultsParser.this.mCurrentRunName = null;
                SubprocessTestResultsParser.this.mCurrentTestCase = null;
            }
        }
    }

    private class TestRunFailedEventHandler
    implements EventHandler {
        private TestRunFailedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.TestRunFailedEventInfo rfi = new SubprocessEventHelper.TestRunFailedEventInfo(new JSONObject(eventJson));
            if (rfi.mFailure != null) {
                SubprocessTestResultsParser.this.mListener.testRunFailed(rfi.mFailure);
            } else {
                SubprocessTestResultsParser.this.mListener.testRunFailed(rfi.mReason);
            }
        }
    }

    private class TestRunStartedEventHandler
    implements EventHandler {
        private TestRunStartedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.TestRunStartedEventInfo rsi = new SubprocessEventHelper.TestRunStartedEventInfo(new JSONObject(eventJson));
            if (rsi.mAttempt != null) {
                SubprocessTestResultsParser.this.mListener.testRunStarted(rsi.mRunName, rsi.mTestCount, rsi.mAttempt, rsi.mStartTime);
            } else {
                SubprocessTestResultsParser.this.mListener.testRunStarted(rsi.mRunName, rsi.mTestCount);
            }
            SubprocessTestResultsParser.this.mCurrentRunName = rsi.mRunName;
        }
    }

    private class TestModuleStartedEventHandler
    implements EventHandler {
        private TestModuleStartedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.TestModuleStartedEventInfo module = new SubprocessEventHelper.TestModuleStartedEventInfo(new JSONObject(eventJson));
            SubprocessTestResultsParser.this.mCurrentModuleContext = module.mModuleContext;
            SubprocessTestResultsParser.this.mListener.testModuleStarted(module.mModuleContext);
        }
    }

    private class TestModuleEndedEventHandler
    implements EventHandler {
        private TestModuleEndedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            if (SubprocessTestResultsParser.this.mCurrentModuleContext == null) {
                LogUtil.CLog.w("Calling testModuleEnded when testModuleStarted was not called.");
            }
            SubprocessTestResultsParser.this.mListener.testModuleEnded();
            SubprocessTestResultsParser.this.mCurrentModuleContext = null;
        }
    }

    private class TestLogEventHandler
    implements EventHandler {
        private TestLogEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.TestLogEventInfo logInfo = new SubprocessEventHelper.TestLogEventInfo(new JSONObject(eventJson));
            if (SubprocessTestResultsParser.this.mIgnoreTestLog) {
                FileUtil.deleteFile(logInfo.mDataFile);
                return;
            }
            String name = String.format("subprocess-%s", logInfo.mDataName);
            try (FileInputStreamSource data = new FileInputStreamSource(logInfo.mDataFile, true);){
                SubprocessTestResultsParser.this.mListener.testLog(name, logInfo.mLogType, data);
                SubprocessTestResultsParser.this.mTestLogged.add(logInfo.mDataName);
            }
        }
    }

    private class LogAssociationEventHandler
    implements EventHandler {
        private LogAssociationEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.LogAssociationEventInfo assosInfo = new SubprocessEventHelper.LogAssociationEventInfo(new JSONObject(eventJson));
            LogFile file2 = assosInfo.mLoggedFile;
            if (Strings.isNullOrEmpty(file2.getPath())) {
                LogUtil.CLog.e("Log '%s' was registered but without a path.", assosInfo.mDataName);
                return;
            }
            File path = new File(file2.getPath());
            String name = String.format("subprocess-%s", assosInfo.mDataName);
            if (Strings.isNullOrEmpty(file2.getUrl()) && path.exists()) {
                if (SubprocessTestResultsParser.this.mTestLogged.contains(assosInfo.mDataName)) {
                    LogUtil.CLog.d("Already called testLog on %s, ignoring the logAssociation.", assosInfo.mDataName);
                    return;
                }
                try (FileInputStreamSource source = new FileInputStreamSource(path, true);){
                    LogDataType type = file2.getType();
                    LogUtil.CLog.d("Logging %s from subprocess: %s ", assosInfo.mDataName, file2.getPath());
                    if ("invocation-trace".equals(assosInfo.mDataName) && LogDataType.PERFETTO.equals((Object)type)) {
                        LogUtil.CLog.d("Log the subprocess trace");
                        TracingLogger.getActiveTrace().addSubprocessTrace(path);
                    }
                    SubprocessTestResultsParser.this.mListener.testLog(name, type, source);
                }
            } else {
                LogUtil.CLog.d("Logging %s from subprocess. url: %s, path: %s", name, file2.getUrl(), file2.getPath());
                if (SubprocessTestResultsParser.this.mListener instanceof ILogSaverListener) {
                    ((ILogSaverListener)SubprocessTestResultsParser.this.mListener).logAssociation(name, assosInfo.mLoggedFile);
                }
            }
        }
    }

    private class InvocationStartedEventHandler
    implements EventHandler {
        private InvocationStartedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            SubprocessEventHelper.InvocationStartedEventInfo eventStart = new SubprocessEventHelper.InvocationStartedEventInfo(new JSONObject(eventJson));
            if (SubprocessTestResultsParser.this.mContext.getTestTag() == null || "stub".equals(SubprocessTestResultsParser.this.mContext.getTestTag())) {
                SubprocessTestResultsParser.this.mContext.setTestTag(eventStart.mTestTag);
            }
            SubprocessTestResultsParser.this.mStartTime = eventStart.mStartTime;
        }
    }

    private class InvocationEndedEventHandler
    implements EventHandler {
        private InvocationEndedEventHandler() {
        }

        @Override
        public void handleEvent(String eventJson) throws JSONException {
            JSONObject json = new JSONObject(eventJson);
            SubprocessEventHelper.InvocationEndedEventInfo eventEnd = new SubprocessEventHelper.InvocationEndedEventInfo(json);
            List<IBuildInfo> infos = SubprocessTestResultsParser.this.mContext.getBuildInfos();
            if (!infos.isEmpty()) {
                Map<String, String> attributes = eventEnd.mBuildAttributes;
                for (InvocationMetricLogger.InvocationGroupMetricKey invocationGroupMetricKey : InvocationMetricLogger.InvocationGroupMetricKey.values()) {
                    HashSet<String> attKeys = new HashSet<String>(attributes.keySet());
                    for (String attKey : attKeys) {
                        if (!attKey.startsWith(invocationGroupMetricKey.toString() + ":")) continue;
                        String value = attributes.remove(attKey);
                        String group = attKey.split(":", 2)[1];
                        if (invocationGroupMetricKey.shouldAdd()) {
                            try {
                                InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, Long.parseLong(value));
                            }
                            catch (NumberFormatException e) {
                                LogUtil.CLog.d("Key %s doesn't have a number value, was: %s.", new Object[]{invocationGroupMetricKey, value});
                                InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, value);
                            }
                        } else {
                            InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, value);
                        }
                        attributes.remove(attKey);
                    }
                }
                for (Enum enum_ : InvocationMetricLogger.InvocationMetricKey.values()) {
                    if (!attributes.containsKey(((InvocationMetricLogger.InvocationMetricKey)enum_).toString())) continue;
                    String val = attributes.remove(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
                    if (((InvocationMetricLogger.InvocationMetricKey)enum_).shouldAdd()) {
                        try {
                            InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, Long.parseLong(val));
                        }
                        catch (NumberFormatException e) {
                            LogUtil.CLog.d("Key %s doesn't have a number value, was: %s.", enum_, val);
                            InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, val);
                        }
                    } else {
                        InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, val);
                    }
                    attributes.remove(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
                }
                if (attributes.containsKey("tf_objects_tracking")) {
                    String val = attributes.get("tf_objects_tracking");
                    for (String pair : Splitter.on(",").split(val)) {
                        if (!pair.contains("=")) continue;
                        String[] stringArray = pair.split("=");
                        try {
                            TfObjectTracker.directCount(stringArray[0], Long.parseLong(stringArray[1]));
                        }
                        catch (NumberFormatException e) {
                            LogUtil.CLog.e(e);
                        }
                    }
                    attributes.remove("tf_objects_tracking");
                }
                infos.get(0).addBuildAttributes(attributes);
            }
        }
    }

    static interface EventHandler {
        public void handleEvent(String var1) throws JSONException;
    }
}

