/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemUtil {
    @VisibleForTesting
    static SystemUtil singleton = new SystemUtil();
    public static final String REMOTE_VM_VARIABLE = "REMOTE_VM_ENV";
    private static final String HOST_TESTCASES = "host/testcases";
    private static final String TARGET_TESTCASES = "target/testcases";
    private static final String LOCAL_AUTH_VARIABLE = "LOCAL_AUTH";
    private static final String LOCAL_MODE = "LOCAL_MODE";
    public static final Map<EnvVariable, String> ENV_VARIABLE_PATHS_IN_TESTS_DIR = new HashMap<EnvVariable, String>();
    static final String ENV_ANDROID_PRODUCT_OUT = "ANDROID_PRODUCT_OUT";

    @VisibleForTesting
    String getEnv(String name) {
        return System.getenv(name);
    }

    public static List<File> getExternalTestCasesDirs() {
        ArrayList<File> testCasesDirs = new ArrayList<File>();
        List<String> testCasesDirNames = Arrays.asList(singleton.getEnv(EnvVariable.ANDROID_TARGET_OUT_TESTCASES.name()), singleton.getEnv(EnvVariable.ANDROID_HOST_OUT_TESTCASES.name()));
        for (String testCasesDirName : testCasesDirNames) {
            if (testCasesDirName == null) continue;
            File dir = new File(testCasesDirName);
            if (dir.exists() && dir.isDirectory()) {
                LogUtil.CLog.d("Found test case dir: %s", testCasesDirName);
                testCasesDirs.add(dir);
                continue;
            }
            LogUtil.CLog.w("Path %s for test cases directory does not exist or it's not a directory.", testCasesDirName);
        }
        return testCasesDirs;
    }

    public static File getExternalTestCasesDir(EnvVariable envVariable) {
        String var = System.getenv(envVariable.name());
        if (var == null) {
            return null;
        }
        File dir = new File(var);
        if (dir.exists() && dir.isDirectory()) {
            LogUtil.CLog.d("Found test case dir: %s for %s.", dir.getAbsolutePath(), envVariable.name());
            return dir;
        }
        return null;
    }

    public static List<File> getTestCasesDirs(IBuildInfo buildInfo) {
        IDeviceBuildInfo deviceBuildInfo;
        File testsDir;
        ArrayList<File> testCasesDirs = new ArrayList<File>();
        testCasesDirs.addAll(SystemUtil.getExternalTestCasesDirs());
        if (buildInfo instanceof IDeviceBuildInfo && (testsDir = (deviceBuildInfo = (IDeviceBuildInfo)buildInfo).getTestsDir()) != null) {
            testCasesDirs.addAll(Arrays.asList(testsDir, FileUtil.getFileForPath(testsDir, HOST_TESTCASES), FileUtil.getFileForPath(testsDir, TARGET_TESTCASES)));
        }
        return testCasesDirs;
    }

    public static File getProductOutputDir() {
        String path = singleton.getEnv(ENV_ANDROID_PRODUCT_OUT);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public static boolean isRemoteEnvironment() {
        return "1".equals(System.getenv(REMOTE_VM_VARIABLE));
    }

    public static boolean isLocalMode() {
        if (System.getenv(LOCAL_MODE) != null) {
            return true;
        }
        return System.getenv(LOCAL_AUTH_VARIABLE) != null;
    }

    public static File getRunningJavaBinaryPath() {
        return SystemUtil.getRunningJavaBinaryPath(false);
    }

    public static File getRunningJavaBinaryPath(boolean skipJavaCheck) {
        String javaHome = System.getProperty("java.home");
        if (!skipJavaCheck) {
            try (TradefedFeatureClient client = new TradefedFeatureClient();){
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("option_name", "jdk-folder-for-subprocess");
                FeatureResponse rep = client.triggerFeature("getCommandOptions", args);
                if (!rep.hasErrorInfo()) {
                    javaHome = rep.getResponse();
                    LogUtil.CLog.d("Using jdk: %s", javaHome);
                }
            }
        }
        if (javaHome == null) {
            throw new RuntimeException("System property \"java.home\" is not set.");
        }
        File javaBinary = new File(String.format("%s/bin/java", javaHome));
        if (!javaBinary.exists()) {
            throw new RuntimeException(String.format("Computed Java binary path %s does not exist", javaBinary));
        }
        return javaBinary;
    }

    static {
        ENV_VARIABLE_PATHS_IN_TESTS_DIR.put(EnvVariable.ANDROID_TARGET_OUT_TESTCASES, TARGET_TESTCASES);
        ENV_VARIABLE_PATHS_IN_TESTS_DIR.put(EnvVariable.ANDROID_HOST_OUT_TESTCASES, HOST_TESTCASES);
    }

    public static enum EnvVariable {
        ANDROID_TARGET_OUT_TESTCASES,
        ANDROID_HOST_OUT_TESTCASES;

    }
}

