/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

public class TableBuilder {
    private int mTableOffset = 2;
    private int mPadding = 1;
    private final int mColumns;
    private int mRowLength;
    private int[] mColumnWidth;
    private List<Line> mTable;
    private StringBuilder mBuilder;

    public TableBuilder(int numColumns) {
        this.mColumns = numColumns;
        this.mColumnWidth = new int[numColumns];
        this.mTable = new LinkedList<Line>();
    }

    public TableBuilder setPadding(int padding) {
        this.mPadding = padding;
        return this;
    }

    public TableBuilder setOffset(int offset) {
        this.mTableOffset = offset;
        return this;
    }

    public TableBuilder addTitle(String title) {
        this.mTable.add(new Separator('+', '=', title));
        return this;
    }

    public TableBuilder addSingleLineSeparator() {
        return this.addSeparator('+', '-');
    }

    public TableBuilder addDoubleLineSeparator() {
        return this.addSeparator('+', '=');
    }

    public TableBuilder addBlankLineSeparator() {
        return this.addSeparator('|', ' ');
    }

    public TableBuilder addSeparator(char end, char pipe) {
        this.mTable.add(new Separator(end, pipe, ""));
        return this;
    }

    public TableBuilder addLine(String line) {
        this.mTable.add(new SingleColumn(line));
        return this;
    }

    public TableBuilder addLine(String[] line) {
        if (line.length != this.mColumns) {
            throw new IllegalArgumentException(String.format("Expect %d columns, actual %d columns", this.mColumns, line.length));
        }
        this.mTable.add(new MultiColumn(line));
        for (int i = 0; i < this.mColumns; ++i) {
            if (line[i].length() <= this.mColumnWidth[i]) continue;
            this.mColumnWidth[i] = line[i].length();
        }
        return this;
    }

    public String build() {
        this.mBuilder = new StringBuilder();
        this.mRowLength = IntStream.of(this.mColumnWidth).map(i -> i + 2 * this.mPadding + 1).sum() + 1;
        for (Line line : this.mTable) {
            line.build();
        }
        return this.mBuilder.toString();
    }

    private void addPadding(int padding) {
        for (int i = 0; i < padding; ++i) {
            this.mBuilder.append(' ');
        }
    }

    private class Separator
    implements Line {
        char mEnd;
        char mPipe;
        String mText;

        Separator(char end, char pipe, String text) {
            this.mEnd = end;
            this.mPipe = pipe;
            this.mText = text;
        }

        @Override
        public void build() {
            int i;
            TableBuilder.this.addPadding(TableBuilder.this.mTableOffset);
            TableBuilder.this.mBuilder.append(this.mEnd);
            int blanks = TableBuilder.this.mRowLength - this.mText.length() - 2;
            for (i = 0; i < blanks / 2; ++i) {
                TableBuilder.this.mBuilder.append(this.mPipe);
            }
            TableBuilder.this.mBuilder.append(this.mText);
            for (i = 0; i < blanks / 2; ++i) {
                TableBuilder.this.mBuilder.append(this.mPipe);
            }
            if (blanks % 2 != 0) {
                TableBuilder.this.mBuilder.append(this.mPipe);
            }
            TableBuilder.this.mBuilder.append(this.mEnd).append('\n');
        }
    }

    private class SingleColumn
    implements Line {
        String mText;

        SingleColumn(String text) {
            this.mText = text;
        }

        @Override
        public void build() {
            int width = TableBuilder.this.mRowLength - 2 - TableBuilder.this.mPadding * 2;
            String text = this.mText;
            while (text != null) {
                TableBuilder.this.addPadding(TableBuilder.this.mTableOffset);
                TableBuilder.this.mBuilder.append('|');
                TableBuilder.this.addPadding(TableBuilder.this.mPadding);
                if (text.length() > width) {
                    TableBuilder.this.mBuilder.append(text.substring(0, width));
                    text = text.substring(width);
                } else {
                    TableBuilder.this.mBuilder.append(text);
                    TableBuilder.this.addPadding(width - text.length());
                    text = null;
                }
                TableBuilder.this.addPadding(TableBuilder.this.mPadding);
                TableBuilder.this.mBuilder.append("|\n");
            }
        }
    }

    private class MultiColumn
    implements Line {
        String[] mColumns;

        MultiColumn(String[] columns) {
            this.mColumns = columns;
        }

        @Override
        public void build() {
            TableBuilder.this.addPadding(TableBuilder.this.mTableOffset);
            TableBuilder.this.mBuilder.append("|");
            for (int i = 0; i < this.mColumns.length; ++i) {
                TableBuilder.this.addPadding(TableBuilder.this.mPadding);
                TableBuilder.this.mBuilder.append(this.mColumns[i]);
                TableBuilder.this.addPadding(TableBuilder.this.mColumnWidth[i] - this.mColumns[i].length() + TableBuilder.this.mPadding);
                TableBuilder.this.mBuilder.append('|');
            }
            TableBuilder.this.mBuilder.append('\n');
        }
    }

    private static interface Line {
        public void build();
    }
}

