/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarUtil {
    private static final byte[] GZIP_SIGNATURE = new byte[]{31, -117};

    public static boolean isGzip(File file2) throws IOException {
        byte[] signature = new byte[GZIP_SIGNATURE.length];
        try (FileInputStream stream = new FileInputStream(file2);){
            if (((InputStream)stream).read(signature) != signature.length) {
                boolean bl = false;
                return bl;
            }
        }
        return Arrays.equals(GZIP_SIGNATURE, signature);
    }

    public static List<File> unTar(File inputFile, File outputDir) throws FileNotFoundException, IOException {
        return TarUtil.unTar(inputFile, outputDir, (String entryName) -> true);
    }

    public static List<File> unTar(File inputFile, File outputDir, Collection<String> fileNames) throws FileNotFoundException, IOException {
        HashSet<String> fileNameSet = new HashSet<String>(fileNames);
        List<File> untarredFiles = TarUtil.unTar(inputFile, outputDir, (String entryName) -> fileNameSet.contains(entryName));
        if (untarredFiles.size() != fileNameSet.size()) {
            HashSet<File> untarredFileSet = new HashSet<File>(untarredFiles);
            String missingFileNames = fileNameSet.stream().filter(name -> !untarredFileSet.contains(new File(outputDir, (String)name))).collect(Collectors.joining(" "));
            throw new IOException(String.format("Couldn't find files in %s: %s", inputFile, missingFileNames));
        }
        return untarredFiles;
    }

    private static List<File> unTar(File inputFile, File outputDir, Predicate<String> shouldExtract) throws FileNotFoundException, IOException {
        LogUtil.CLog.i(String.format("Untaring %s to dir %s.", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        LinkedList<File> untaredFiles = new LinkedList<File>();
        FileInputStream is = new FileInputStream(inputFile);
        TarArchiveInputStream debInputStream = null;
        try {
            debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                if (!shouldExtract.test(entry.getName())) continue;
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    LogUtil.CLog.i(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                    if (!outputFile.exists()) {
                        LogUtil.CLog.i(String.format("Attempting to create output directory %s.", outputFile.getAbsolutePath()));
                        if (!outputFile.mkdirs()) {
                            throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                        }
                    }
                } else {
                    File parent = outputFile.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        throw new IOException(String.format("Couldn't create directory %s.", parent.getAbsolutePath()));
                    }
                    if (entry.isSymbolicLink()) {
                        LogUtil.CLog.i(String.format("Creating symbolic link %s -> %s.", outputFile.getAbsolutePath(), entry.getLinkName()));
                        FileUtil.symlinkFile(new File(entry.getLinkName()), outputFile);
                    } else {
                        LogUtil.CLog.i(String.format("Creating file %s.", outputFile.getAbsolutePath()));
                        try (FileOutputStream outputFileStream = new FileOutputStream(outputFile);){
                            IOUtils.copy(debInputStream, outputFileStream);
                        }
                    }
                }
                untaredFiles.add(outputFile);
            }
        }
        catch (ArchiveException ae) {
            try {
                throw new IOException(ae);
            }
            catch (Throwable throwable) {
                StreamUtil.close(debInputStream);
                StreamUtil.close(is);
                throw throwable;
            }
        }
        StreamUtil.close(debInputStream);
        StreamUtil.close(is);
        return untaredFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unGzip(File inputFile, File outputDir) throws FileNotFoundException, IOException {
        LogUtil.CLog.i(String.format("Ungzipping %s to dir %s.", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        File outputFile = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().length() - 3));
        GZIPInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new GZIPInputStream(new FileInputStream(inputFile));
            out = new FileOutputStream(outputFile);
            IOUtils.copy(in, out);
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(in);
        StreamUtil.close(out);
        return outputFile;
    }

    public static File gzip(File inputFile) throws IOException {
        File outputFile = FileUtil.createTempFile(inputFile.getName(), ".gz");
        GZIPOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            in = new FileInputStream(inputFile);
            IOUtils.copy(in, out);
        }
        catch (IOException e) {
            try {
                FileUtil.deleteFile(outputFile);
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.close(in);
                StreamUtil.close(out);
                throw throwable;
            }
        }
        StreamUtil.close(in);
        StreamUtil.close(out);
        return outputFile;
    }

    public static File extractTarGzipToTemp(File targzFile, String nameHint) throws FileNotFoundException, IOException {
        File unGzipDir = null;
        File unTarDir = null;
        try {
            unGzipDir = FileUtil.createTempDir("extractTarGzip");
            File tarFile = TarUtil.unGzip(targzFile, unGzipDir);
            unTarDir = FileUtil.createTempDir(nameHint);
            TarUtil.unTar(tarFile, unTarDir);
            File file2 = unTarDir;
            return file2;
        }
        catch (IOException e) {
            FileUtil.recursiveDelete(unTarDir);
            throw e;
        }
        finally {
            FileUtil.recursiveDelete(unGzipDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractAndLog(ITestLogger listener, File targzFile, String baseName) throws FileNotFoundException, IOException {
        FileInputStreamSource inputStream = null;
        try {
            inputStream = new FileInputStreamSource(targzFile);
            listener.testLog(baseName, LogDataType.TAR_GZ, inputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.cancel(inputStream);
            throw throwable;
        }
        StreamUtil.cancel(inputStream);
        File dir = FileUtil.createTempDir("tmp_tar_dir");
        File ungzipLog = null;
        try {
            ungzipLog = TarUtil.unGzip(targzFile, dir);
            List<File> logs = TarUtil.unTar(ungzipLog, dir);
            for (File f : logs) {
                FileInputStreamSource s = null;
                try {
                    s = new FileInputStreamSource(f);
                    listener.testLog(String.format("%s_%s", baseName, f.getName()), LogDataType.TEXT, s);
                }
                catch (Throwable throwable) {
                    StreamUtil.cancel(s);
                    throw throwable;
                    return;
                }
                StreamUtil.cancel(s);
            }
        }
        finally {
            FileUtil.deleteFile(ungzipLog);
            FileUtil.recursiveDelete(dir);
        }
    }
}

