/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TargetFileUtils {
    private static final int PERMISSION_GROUPS = 3;

    public static boolean hasPermission(FilePermission permission, String permissionBits) {
        for (int i = 0; i < 3; ++i) {
            if (!TargetFileUtils.hasPermission(permissionBits, i, permission)) continue;
            return true;
        }
        return false;
    }

    public static String getPermission(String filepath, ITestDevice device) throws DeviceNotAvailableException {
        CommandResult commandResult = device.executeShellV2Command("stat -c %a " + filepath);
        if (!CommandStatus.SUCCESS.equals((Object)commandResult.getStatus())) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, "Get permission error:\nstdout%s\nstderr", commandResult.getStdout(), commandResult.getStderr());
            return "";
        }
        return commandResult.getStdout().trim();
    }

    private static boolean hasPermission(String permissionBits, int groupIndex, FilePermission permission) {
        if (groupIndex >= 3) {
            throw new RuntimeException(String.format("Invalid group: %s", groupIndex));
        }
        if (permissionBits.length() != 3) {
            throw new RuntimeException(String.format("Invalid permission bits: %s", permissionBits.length() + ""));
        }
        int start = groupIndex;
        int end = groupIndex + 1;
        if (groupIndex < 0) {
            start = 0;
            end = 3;
        }
        for (int i = start; i < end; ++i) {
            try {
                int perm = Integer.valueOf(permissionBits.charAt(i) + "");
                if (perm > 7) {
                    throw new RuntimeException(String.format("Invalid permission bit: %d", perm));
                }
                if ((perm & permission.getPermissionNum()) != 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("Permission bits \"%s\" format error, should be three digital number (e.q. 741).", permissionBits));
            }
        }
        return true;
    }

    public static ArrayList<String> findFile(String path, String namePattern, List<String> options, ITestDevice device) throws DeviceNotAvailableException {
        ArrayList<Object> findedFiles = new ArrayList();
        String command = String.format("find %s -name \"%s\"", path, namePattern);
        if (options != null) {
            command = command + " " + String.join((CharSequence)" ", options);
        }
        LogUtil.CLog.d("command: %s", command);
        CommandResult result = device.executeShellV2Command(command);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            LogUtil.CLog.e("Find command: '%s' failed, returned:\nstdout:%s\nstderr:%s", command, result.getStdout(), result.getStderr());
            return findedFiles;
        }
        findedFiles = new ArrayList<String>(Arrays.asList(result.getStdout().split("\n")));
        findedFiles.removeIf(s -> s.contentEquals(""));
        return findedFiles;
    }

    public static boolean isReadOnly(String filepath, ITestDevice device) throws DeviceNotAvailableException {
        String permissionBits = TargetFileUtils.getPermission(filepath, device);
        return TargetFileUtils.hasPermission(FilePermission.READ, permissionBits) && !TargetFileUtils.hasPermission(FilePermission.WRITE, permissionBits) && !TargetFileUtils.hasPermission(FilePermission.EXECUTE, permissionBits);
    }

    public static boolean isReadWriteOnly(String filepath, ITestDevice device) throws DeviceNotAvailableException {
        String permissionBits = TargetFileUtils.getPermission(filepath, device);
        return TargetFileUtils.hasPermission(FilePermission.READ, permissionBits) && TargetFileUtils.hasPermission(FilePermission.WRITE, permissionBits) && !TargetFileUtils.hasPermission(FilePermission.EXECUTE, permissionBits);
    }

    public static enum FilePermission {
        EXECUTE(1),
        READ(4),
        WRITE(2);

        private int mPermissionNum;

        private FilePermission(int permissionNum) {
            this.mPermissionNum = permissionNum;
        }

        public int getPermissionNum() {
            return this.mPermissionNum;
        }
    }
}

