/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.runner.Description;

public class TestFilterHelper {
    private Set<String> mIncludeFilters = new HashSet<String>();
    private Set<String> mExcludeFilters = new HashSet<String>();
    private Set<String> mIncludeAnnotations = new HashSet<String>();
    private Set<String> mExcludeAnnotations = new HashSet<String>();

    public TestFilterHelper() {
    }

    public TestFilterHelper(Collection<String> includeFilters, Collection<String> excludeFilters, Collection<String> includeAnnotation, Collection<String> excludeAnnotation) {
        this.mIncludeFilters.addAll(includeFilters);
        this.mExcludeFilters.addAll(excludeFilters);
        this.mIncludeAnnotations.addAll(includeAnnotation);
        this.mExcludeAnnotations.addAll(excludeAnnotation);
    }

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotations.add(annotation);
    }

    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotations.addAll(annotations);
    }

    public void addExcludeAnnotation(String notAnnotation) {
        this.mExcludeAnnotations.add(notAnnotation);
    }

    public void addAllExcludeAnnotation(Set<String> notAnnotations) {
        this.mExcludeAnnotations.addAll(notAnnotations);
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeAnnotation() {
        return this.mIncludeAnnotations;
    }

    public Set<String> getExcludeAnnotation() {
        return this.mExcludeAnnotations;
    }

    public void clearIncludeAnnotations() {
        this.mIncludeAnnotations.clear();
    }

    public void clearExcludeAnnotations() {
        this.mExcludeAnnotations.clear();
    }

    public boolean shouldTestRun(AnnotatedElement annotatedElement) {
        return this.shouldTestRun(Arrays.asList(annotatedElement.getAnnotations()));
    }

    public boolean shouldTestRun(Description desc) {
        return this.shouldTestRun(desc.getAnnotations());
    }

    private boolean shouldTestRun(Collection<Annotation> annotationsList) {
        if (this.isExcluded(annotationsList)) {
            return false;
        }
        return this.isIncluded(annotationsList);
    }

    private boolean isExcluded(Collection<Annotation> annotationsList) {
        if (!this.mExcludeAnnotations.isEmpty()) {
            for (Annotation a : annotationsList) {
                if (!this.mExcludeAnnotations.contains(a.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIncluded(Collection<Annotation> annotationsList) {
        if (!this.mIncludeAnnotations.isEmpty()) {
            HashSet<String> neededAnnotation = new HashSet<String>();
            neededAnnotation.addAll(this.mIncludeAnnotations);
            for (Annotation a : annotationsList) {
                if (!neededAnnotation.contains(a.annotationType().getName())) continue;
                neededAnnotation.remove(a.annotationType().getName());
            }
            if (neededAnnotation.size() != 0) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldRun(String packageName, Class<?> classObj, Method method) {
        String methodName;
        String className = classObj.getName();
        if (!this.shouldRunFilter(packageName, className, methodName = String.format("%s#%s", className, method.getName()))) {
            return false;
        }
        if (this.isExcluded(Arrays.asList(classObj.getAnnotations()))) {
            return false;
        }
        if (this.isIncluded(Arrays.asList(classObj.getAnnotations())) && this.isExcluded(Arrays.asList(method.getAnnotations()))) {
            return false;
        }
        if (!(!this.mIncludeAnnotations.isEmpty() && this.isIncluded(Arrays.asList(classObj.getAnnotations())) || this.shouldTestRun(method))) {
            return false;
        }
        return this.mIncludeFilters.isEmpty() || this.mIncludeFilters.contains(methodName) || this.mIncludeFilters.contains(className) || this.mIncludeFilters.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun(Description desc, List<File> extraJars) {
        String methodName;
        String className;
        String packageName;
        URLClassLoader cl;
        block10: {
            Class<?> classObj;
            block9: {
                block8: {
                    boolean e2;
                    classObj = null;
                    cl = null;
                    try {
                        try {
                            ArrayList<URL> urlList = new ArrayList<URL>();
                            for (File f : extraJars) {
                                urlList.add(f.toURI().toURL());
                            }
                            cl = URLClassLoader.newInstance(urlList.toArray(new URL[0]));
                            classObj = cl.loadClass(desc.getClassName());
                        }
                        catch (ClassNotFoundException | MalformedURLException e2) {
                            throw new HarnessRuntimeException(String.format("Could not load Test class %s", desc.getClassName()), e2, InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                        }
                        if (!this.isExcluded(Arrays.asList(classObj.getAnnotations()))) break block8;
                        e2 = false;
                    }
                    catch (Throwable throwable) {
                        StreamUtil.close(cl);
                        throw throwable;
                    }
                    StreamUtil.close(cl);
                    return e2;
                }
                packageName = classObj.getPackage().getName();
                className = desc.getClassName();
                methodName = String.format("%s#%s", className, desc.getMethodName());
                if (this.shouldRunFilter(packageName, className, methodName)) break block9;
                boolean bl = false;
                StreamUtil.close(cl);
                return bl;
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>(desc.getAnnotations());
            annotations.addAll(Arrays.asList(classObj.getAnnotations()));
            if (this.shouldTestRun(annotations)) break block10;
            boolean bl = false;
            StreamUtil.close(cl);
            return bl;
        }
        boolean bl = this.mIncludeFilters.isEmpty() || this.mIncludeFilters.contains(methodName) || this.mIncludeFilters.contains(className) || this.mIncludeFilters.contains(packageName);
        StreamUtil.close(cl);
        return bl;
    }

    private boolean shouldRunFilter(String packageName, String className, String methodName) {
        if (this.mExcludeFilters.contains(packageName)) {
            return false;
        }
        if (this.mExcludeFilters.contains(className)) {
            return false;
        }
        return !this.mExcludeFilters.contains(methodName);
    }
}

