/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.util.ArrayList;

public class TestRunnerUtil {
    static TestRunnerUtil singleton = new TestRunnerUtil();

    String getEnv(String name) {
        return System.getenv(name);
    }

    public static String getLdLibraryPath(File testFile) {
        ArrayList<String> paths = new ArrayList<String>();
        String[] libs = new String[]{"lib", "lib64"};
        String androidHostOut = singleton.getEnv("ANDROID_HOST_OUT");
        String testcasesFolderPath = TestRunnerUtil.getTestcasesFolderPath(testFile);
        for (String lib : libs) {
            File libFile = new File(testFile.getParentFile().getAbsolutePath(), lib);
            if (libFile.exists()) {
                paths.add(libFile.getAbsolutePath());
            }
            if (testcasesFolderPath != null && (libFile = new File(testcasesFolderPath, lib)).exists()) {
                paths.add(libFile.getAbsolutePath());
            }
            if (androidHostOut == null || !(libFile = new File(androidHostOut, lib)).exists()) continue;
            paths.add(libFile.getAbsolutePath());
        }
        if (paths.isEmpty()) {
            return null;
        }
        String ldLibraryPath = String.join((CharSequence)File.pathSeparator, paths);
        LogUtil.CLog.d("Identify LD_LIBRARY_PATH to be used: %s", ldLibraryPath);
        return ldLibraryPath;
    }

    private static String getTestcasesFolderPath(File testFile) {
        File folder = testFile.getParentFile();
        if (folder != null && (folder = folder.getParentFile()) != null && (folder = folder.getParentFile()) != null) {
            return folder.getAbsolutePath();
        }
        return null;
    }
}

