/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private TimeUtil() {
    }

    public static String formatElapsedTime(long elapsedTimeMs) {
        if (elapsedTimeMs < 1000L) {
            return String.format("%d ms", elapsedTimeMs);
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(elapsedTimeMs) % 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(elapsedTimeMs) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(elapsedTimeMs);
        StringBuilder time = new StringBuilder();
        if (hours > 0L) {
            time.append(hours);
            time.append("h ");
        }
        if (minutes > 0L) {
            time.append(minutes);
            time.append("m ");
        }
        time.append(seconds);
        time.append("s");
        return time.toString();
    }

    public static String formatTimeStamp(long epochTime) {
        return TimeUtil.formatTimeStamp(epochTime, null);
    }

    private static String formatTimeStamp(long epochTime, SimpleDateFormat format) {
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return format.format(new Date(epochTime));
    }

    public static String formatTimeStampGMT(long epochTime) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return TimeUtil.formatTimeStamp(epochTime, timeFormat);
    }
}

