/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.google.common.math.LongMath;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeVal
extends Number
implements Comparable<Long> {
    private static final Pattern TIME_PATTERN = Pattern.compile("(?i)(?:(?<d>\\d+)d)?(?:(?<h>\\d+)h)?(?:(?<m>\\d+)m)?(?:(?<s>\\d+)s)?(?:(?<ms>\\d+)(?:ms)?)?");
    private Long mValue = null;

    public TimeVal(Long value) {
        this.mValue = value;
    }

    public TimeVal(String value) throws NumberFormatException {
        this.mValue = TimeVal.fromString(value);
    }

    public Long asLong() {
        return this.mValue;
    }

    public static long fromString(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("value is null");
        }
        try {
            value = value.replaceAll("\\s+", "");
            Matcher m = TIME_PATTERN.matcher(value);
            if (m.matches()) {
                long timeValue = 0L;
                timeValue = TimeVal.val(m.group("d"));
                timeValue = LongMath.checkedMultiply(timeValue, 24L);
                timeValue = LongMath.checkedAdd(timeValue, TimeVal.val(m.group("h")));
                timeValue = LongMath.checkedMultiply(timeValue, 60L);
                timeValue = LongMath.checkedAdd(timeValue, TimeVal.val(m.group("m")));
                timeValue = LongMath.checkedMultiply(timeValue, 60L);
                timeValue = LongMath.checkedAdd(timeValue, TimeVal.val(m.group("s")));
                timeValue = LongMath.checkedMultiply(timeValue, 1000L);
                timeValue = LongMath.checkedAdd(timeValue, TimeVal.val(m.group("ms")));
                return timeValue;
            }
        }
        catch (ArithmeticException e) {
            throw new NumberFormatException(String.format("Failed to parse value %s as a time value: %s", value, e.getMessage()));
        }
        throw new NumberFormatException(String.format("Failed to parse value %s as a time value", value));
    }

    static long val(String str) throws NumberFormatException {
        if (str == null) {
            return 0L;
        }
        long value = Long.parseLong(str);
        return value;
    }

    @Override
    public double doubleValue() {
        return this.mValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.mValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.mValue.intValue();
    }

    @Override
    public long longValue() {
        return this.mValue;
    }

    @Override
    public int compareTo(Long other) {
        return this.mValue.compareTo(other);
    }
}

