/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class VersionParser {
    public static final String DEFAULT_IMPLEMENTATION_VERSION = "default";
    private static final String VERSION_FILE = "version.txt";
    private static final String TF_MAIN_JAR = "/tradefed.jar";

    public static String fetchVersion() {
        return VersionParser.getPackageVersion();
    }

    private static String getPackageVersion() {
        String packageVersion;
        Package p = VersionParser.class.getPackage();
        if (p != null && (packageVersion = p.getImplementationVersion()) != null && !DEFAULT_IMPLEMENTATION_VERSION.equals(packageVersion)) {
            return packageVersion;
        }
        File dir = VersionParser.getTradefedJarDir();
        if (dir != null) {
            File versionFile = new File(dir, VERSION_FILE);
            if (versionFile.exists()) {
                try {
                    String version = FileUtil.readStringFromFile(versionFile);
                    return version.trim();
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
            }
            LogUtil.CLog.e("Did not find Version file in directory: %s", dir.getAbsolutePath());
        }
        return null;
    }

    private static File getTradefedJarDir() {
        try {
            File f = new File(VersionParser.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            return f.getParentFile();
        }
        catch (Exception e) {
            LogUtil.CLog.e("Failed to find TF JAR dir:");
            LogUtil.CLog.e(e);
            return null;
        }
    }
}

