/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.zip.CentralDirectoryInfo;
import com.android.tradefed.util.zip.EndCentralDirectoryInfo;
import com.android.tradefed.util.zip.LocalFileHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int COMPRESSION_METHOD_STORED = 0;
    private static final int COMPRESSION_METHOD_DEFLATE = 8;
    private static final String DEFAULT_DIRNAME = "dir";
    private static final String DEFAULT_FILENAME = "files";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String PARTIAL_ZIP_DATA = "compressed_data";
    private static final boolean IS_UNIX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFileValid(File zipFile, boolean thorough) throws IOException {
        block12: {
            if (zipFile == null) {
                LogUtil.CLog.d("isZipFileValid received a null file reference.");
                return false;
            }
            if (!zipFile.exists()) {
                LogUtil.CLog.d("Zip file does not exist: %s", zipFile.getAbsolutePath());
                return false;
            }
            try (ZipFile z = new ZipFile(zipFile);){
                if (!thorough) break block12;
                File extractDir = FileUtil.createTempDir("extract-" + zipFile.getName());
                try {
                    ZipUtil.extractZip(z, extractDir);
                }
                finally {
                    FileUtil.recursiveDelete(extractDir);
                }
            }
            catch (ZipException e) {
                LogUtil.CLog.d("Detected corrupt zip file %s:", zipFile.getCanonicalPath());
                LogUtil.CLog.e(e);
                return false;
            }
        }
        return true;
    }

    public static void extractZip(ZipFile zipFile, File destDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File childFile = new File(destDir, entry.getName());
            childFile.getParentFile().mkdirs();
            if (entry.isDirectory()) {
                childFile.mkdirs();
                continue;
            }
            FileUtil.writeToFile(zipFile.getInputStream(entry), childFile);
        }
    }

    public static void extractZip(ZipFile zipFile, File destDir, Predicate<ZipEntry> shouldExtract) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File childFile = new File(destDir, entry.getName());
            childFile.getParentFile().mkdirs();
            if (entry.isDirectory() || !shouldExtract.test(entry)) continue;
            FileUtil.writeToFile(zipFile.getInputStream(entry), childFile);
        }
    }

    public static File extractFileFromZip(ZipFile zipFile, String filePath) throws IOException {
        ZipEntry entry = zipFile.getEntry(filePath);
        if (entry == null) {
            return null;
        }
        File createdFile = FileUtil.createTempFile("extracted", FileUtil.getExtension(filePath));
        FileUtil.writeToFile(zipFile.getInputStream(entry), createdFile);
        return createdFile;
    }

    public static File createZip(File dir) throws IOException {
        return ZipUtil.createZip(dir, DEFAULT_DIRNAME);
    }

    public static File createZip(File dir, String name) throws IOException {
        File zipFile = FileUtil.createTempFile(name, ZIP_EXTENSION);
        ZipUtil.createZip(dir, zipFile);
        return zipFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createZip(File dir, File zipFile) throws IOException {
        ZipOutputStream out = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(new BufferedOutputStream(fileStream));
            ZipUtil.addToZip(out, dir, new LinkedList<String>());
        }
        catch (IOException e) {
            try {
                zipFile.delete();
                throw e;
                catch (RuntimeException e2) {
                    zipFile.delete();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                throw throwable;
            }
        }
        StreamUtil.close(out);
    }

    public static File createZip(List<File> files) throws IOException {
        return ZipUtil.createZip(files, DEFAULT_FILENAME);
    }

    public static File createZip(List<File> files, String name) throws IOException {
        File zipFile = FileUtil.createTempFile(name, ZIP_EXTENSION);
        ZipUtil.createZip(files, zipFile);
        return zipFile;
    }

    public static void createZip(List<File> files, File zipFile) throws IOException {
        ZipOutputStream out = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(new BufferedOutputStream(fileStream));
            for (File file2 : files) {
                ZipUtil.addToZip(out, file2, new LinkedList<String>());
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                zipFile.delete();
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                throw throwable;
            }
        }
        StreamUtil.close(out);
    }

    public static void addToZip(ZipOutputStream out, File file2, List<String> relativePathSegs) throws IOException {
        relativePathSegs.add(file2.getName());
        if (file2.isDirectory()) {
            relativePathSegs.add("/");
        }
        ZipEntry zipEntry = new ZipEntry(ZipUtil.buildPath(relativePathSegs));
        out.putNextEntry(zipEntry);
        if (file2.isFile()) {
            ZipUtil.writeToStream(file2, out);
        }
        out.closeEntry();
        if (file2.isDirectory()) {
            File[] subFiles = file2.listFiles();
            if (subFiles == null) {
                throw new IOException(String.format("Could not read directory %s", file2.getAbsolutePath()));
            }
            for (File subFile : subFiles) {
                ZipUtil.addToZip(out, subFile, relativePathSegs);
            }
            relativePathSegs.remove(relativePathSegs.size() - 1);
        }
        relativePathSegs.remove(relativePathSegs.size() - 1);
    }

    public static void closeZip(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gzipFile(File file2, File gzipFile) throws IOException {
        GZIPOutputStream out = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(gzipFile);
            out = new GZIPOutputStream(new BufferedOutputStream(fileStream, 65536));
            ZipUtil.writeToStream(file2, out);
        }
        catch (IOException e) {
            try {
                gzipFile.delete();
                throw e;
                catch (RuntimeException e2) {
                    gzipFile.delete();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                throw throwable;
            }
        }
        StreamUtil.close(out);
    }

    private static void writeToStream(File file2, OutputStream out) throws IOException {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file2));
            StreamUtil.copyStreams(inputStream, out);
        }
        catch (Throwable throwable) {
            StreamUtil.close(inputStream);
            throw throwable;
        }
        StreamUtil.close(inputStream);
    }

    private static String buildPath(List<String> relativePathSegs) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : relativePathSegs) {
            pathBuilder.append(segment);
        }
        return pathBuilder.toString();
    }

    public static File extractZipToTemp(File zipFile, String nameHint) throws IOException, ZipException {
        File file2;
        File localRootDir = FileUtil.createTempDir(nameHint);
        ZipFile zip = new ZipFile(zipFile);
        try {
            ZipUtil.extractZip(zip, localRootDir);
            file2 = localRootDir;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                FileUtil.recursiveDelete(localRootDir);
                throw e;
            }
        }
        zip.close();
        return file2;
    }

    public static List<CentralDirectoryInfo> getZipCentralDirectoryInfos(File partialZipFile, EndCentralDirectoryInfo endCentralDirInfo, boolean useZip64) throws IOException {
        try (CloseableTraceScope ignored = new CloseableTraceScope("getZipCentralDirectoryInfos:" + partialZipFile.getName());){
            List<CentralDirectoryInfo> list2 = ZipUtil.getZipCentralDirectoryInfos(partialZipFile, endCentralDirInfo, 0L, useZip64);
            return list2;
        }
    }

    public static List<CentralDirectoryInfo> getZipCentralDirectoryInfos(File partialZipFile, EndCentralDirectoryInfo endCentralDirInfo, long offset) throws IOException {
        return ZipUtil.getZipCentralDirectoryInfos(partialZipFile, endCentralDirInfo, offset, false);
    }

    public static List<CentralDirectoryInfo> getZipCentralDirectoryInfos(File partialZipFile, EndCentralDirectoryInfo endCentralDirInfo) throws IOException {
        return ZipUtil.getZipCentralDirectoryInfos(partialZipFile, endCentralDirInfo, 0L, false);
    }

    public static List<CentralDirectoryInfo> getZipCentralDirectoryInfos(File partialZipFile, EndCentralDirectoryInfo endCentralDirInfo, long offset, boolean useZip64) throws IOException {
        byte[] data;
        ArrayList<CentralDirectoryInfo> infos = new ArrayList<CentralDirectoryInfo>();
        try (FileInputStream stream = new FileInputStream(partialZipFile);){
            long totalSize = stream.getChannel().size();
            stream.skip(offset);
            data = new byte[(int)(totalSize - offset)];
            stream.read(data);
        }
        int startOffset = 0;
        int i = 0;
        while ((long)i < endCentralDirInfo.getEntryNumber()) {
            CentralDirectoryInfo info = new CentralDirectoryInfo(data, startOffset, useZip64);
            infos.add(info);
            startOffset += info.getInfoSize();
            ++i;
        }
        return infos;
    }

    public static void applyPermission(File targetFile, CentralDirectoryInfo zipEntry) throws IOException {
        if (!IS_UNIX) {
            LogUtil.CLog.w("Permission setting is only supported in Unix/Linux system.");
            return;
        }
        if (zipEntry.getFilePermission() != 0) {
            Files.setPosixFilePermissions(targetFile.toPath(), FileUtil.unixModeToPosix(zipEntry.getFilePermission()));
        }
    }

    public static void unzipPartialZipFolder(File targetFile, CentralDirectoryInfo zipEntry) throws IOException {
        ZipUtil.unzipPartialZipFile(null, targetFile, zipEntry, null, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipPartialZipFile(File partialZip, File targetFile, CentralDirectoryInfo zipEntry, LocalFileHeader localFileHeader, long startOffset) throws IOException {
        block25: {
            try {
                if (zipEntry.getFileName().endsWith("/")) {
                    targetFile.mkdir();
                    return;
                }
                if (zipEntry.getCompressedSize() == 0) {
                    targetFile.getParentFile().mkdirs();
                    targetFile.createNewFile();
                    return;
                }
                File zipFile = targetFile;
                if (zipEntry.getCompressionMethod() != 0) {
                    zipFile = FileUtil.createTempFile(PARTIAL_ZIP_DATA, ZIP_EXTENSION);
                } else {
                    zipFile.getParentFile().mkdirs();
                    zipFile.createNewFile();
                }
                try (FileInputStream stream = new FileInputStream(partialZip);){
                    FileUtil.writeToFile(stream, zipFile, false, startOffset + (long)localFileHeader.getHeaderSize(), zipEntry.getCompressedSize());
                }
                if (zipEntry.getCompressionMethod() == 0) {
                    return;
                }
                if (zipEntry.getCompressionMethod() == 8) {
                    boolean success = false;
                    try {
                        ZipUtil.unzipRawZip(zipFile, targetFile, zipEntry);
                        success = true;
                        zipFile.delete();
                    }
                    catch (DataFormatException e) {
                        try {
                            throw new IOException(e);
                        }
                        catch (Throwable throwable) {
                            zipFile.delete();
                            if (!success) {
                                LogUtil.CLog.e("Failed to unzip %s", zipEntry.getFileName());
                                targetFile.delete();
                            }
                            throw throwable;
                        }
                    }
                    if (!success) {
                        LogUtil.CLog.e("Failed to unzip %s", zipEntry.getFileName());
                        targetFile.delete();
                    }
                    break block25;
                }
                throw new RuntimeException(String.format("Compression method %d is not supported.", localFileHeader.getCompressionMethod()));
            }
            finally {
                if (targetFile.exists()) {
                    ZipUtil.applyPermission(targetFile, zipEntry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipRawZip(File zipFile, File targetFile, CentralDirectoryInfo zipEntry) throws IOException, DataFormatException {
        Inflater decompresser = new Inflater(true);
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        try (FileInputStream inputStream = new FileInputStream(zipFile);
             FileOutputStream outputStream = new FileOutputStream(targetFile);){
            byte[] data = new byte[32768];
            byte[] buffer = new byte[65536];
            while (inputStream.read(data) > 0) {
                decompresser.setInput(data);
                while (!decompresser.finished() && !decompresser.needsInput()) {
                    int size = decompresser.inflate(buffer);
                    outputStream.write(buffer, 0, size);
                }
            }
        }
        finally {
            decompresser.end();
        }
        long targetFileCrc = FileUtil.calculateCrc32(targetFile);
        if (targetFileCrc != zipEntry.getCrc()) {
            throw new IOException(String.format("Failed to match CRC for file %s [expected=%s, actual=%s]", targetFile, zipEntry.getCrc(), targetFileCrc));
        }
    }

    static {
        String OS = System.getProperty("os.name").toLowerCase();
        IS_UNIX = OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }
}

