/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.error.HarnessIOException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ZipUtil2 {
    private static boolean applyUnixModeIfNecessary(ZipArchiveEntry entry, File localFile) throws IOException {
        if (entry.getPlatform() == 3) {
            Files.setPosixFilePermissions(localFile.toPath(), FileUtil.unixModeToPosix(entry.getUnixMode()));
            return true;
        }
        return false;
    }

    private static boolean extractZipEntry(org.apache.commons.compress.archivers.zip.ZipFile zipFile, ZipArchiveEntry entry, File destFile) throws IOException {
        FileUtil.writeToFile(zipFile.getInputStream(entry), destFile);
        return ZipUtil2.applyUnixModeIfNecessary(entry, destFile);
    }

    public static void extractZip(org.apache.commons.compress.archivers.zip.ZipFile zipFile, File destDir) throws IOException {
        Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
        HashSet<String> noPermissions = new HashSet<String>();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            File childFile = new File(destDir, entry.getName());
            childFile.getParentFile().mkdirs();
            if (entry.isDirectory()) {
                childFile.mkdirs();
                if (ZipUtil2.applyUnixModeIfNecessary(entry, childFile)) continue;
                noPermissions.add(entry.getName());
                continue;
            }
            if (ZipUtil2.extractZipEntry(zipFile, entry, childFile)) continue;
            noPermissions.add(entry.getName());
        }
        if (!noPermissions.isEmpty()) {
            LogUtil.CLog.d("Entries '%s' exist but do not contain Unix mode permission info. Files will have default permission.", noPermissions);
        }
    }

    public static void extractZip(File toUnzip, File destDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(toUnzip);){
            ZipUtil.extractZip(zipFile, destDir);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                throw new HarnessIOException(e, InfraErrorIdentifier.ARTIFACT_INVALID);
            }
            throw e;
        }
        try (org.apache.commons.compress.archivers.zip.ZipFile zip = new org.apache.commons.compress.archivers.zip.ZipFile(toUnzip);){
            ZipUtil2.restorePermissions(zip, destDir);
        }
    }

    public static boolean extractFileFromZip(org.apache.commons.compress.archivers.zip.ZipFile zipFile, String filePath, File destFile) throws IOException {
        ZipArchiveEntry entry = zipFile.getEntry(filePath);
        if (entry == null) {
            return false;
        }
        ZipUtil2.extractZipEntry(zipFile, entry, destFile);
        return true;
    }

    public static File extractFileFromZip(org.apache.commons.compress.archivers.zip.ZipFile zipFile, String filePath) throws IOException {
        ZipArchiveEntry entry = zipFile.getEntry(filePath);
        if (entry == null) {
            return null;
        }
        File createdFile = FileUtil.createTempFile("extracted", FileUtil.getExtension(filePath));
        ZipUtil2.extractZipEntry(zipFile, entry, createdFile);
        return createdFile;
    }

    public static File extractZipToTemp(File zipFile, String nameHint) throws IOException {
        File localRootDir = FileUtil.createTempDir(nameHint);
        try {
            ZipUtil2.extractZip(zipFile, localRootDir);
            return localRootDir;
        }
        catch (IOException e) {
            FileUtil.recursiveDelete(localRootDir);
            throw e;
        }
    }

    public static void closeZip(org.apache.commons.compress.archivers.zip.ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void restorePermissions(org.apache.commons.compress.archivers.zip.ZipFile zipFile, File destDir) throws IOException {
        Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
        HashSet<String> noPermissions = new HashSet<String>();
        while (entries.hasMoreElements()) {
            File childFile;
            ZipArchiveEntry entry = entries.nextElement();
            if (ZipUtil2.applyUnixModeIfNecessary(entry, childFile = new File(destDir, entry.getName()))) continue;
            noPermissions.add(entry.getName());
        }
        if (!noPermissions.isEmpty()) {
            LogUtil.CLog.e("Entries '%s' exist but do not contain Unix mode permission info. Files will have default permission.", noPermissions);
        }
    }
}

