/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.executor;

import com.android.tradefed.invoker.tracing.TracePropagatingExecutorService;
import com.android.tradefed.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ParallelDeviceExecutor<V> {
    private final int mPoolSize;
    private List<Throwable> mErrors;

    public ParallelDeviceExecutor(int poolSize) {
        this.mPoolSize = poolSize;
        this.mErrors = new ArrayList<Throwable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> invokeAll(List<Callable<V>> callableTasks, long timeout, TimeUnit unit) {
        ArrayList<V> results = new ArrayList<V>();
        if (callableTasks.isEmpty()) {
            return results;
        }
        TracePropagatingExecutorService executor = TracePropagatingExecutorService.create(Executors.newFixedThreadPool(this.mPoolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }));
        try {
            List<Future<V>> futures = timeout == 0L ? executor.invokeAll(callableTasks) : executor.invokeAll(callableTasks, timeout, unit);
            for (Future<V> future : futures) {
                try {
                    results.add(future.get());
                }
                catch (CancellationException cancellationException) {
                    this.mErrors.add(cancellationException);
                }
                catch (ExecutionException execException) {
                    this.mErrors.add(execException.getCause());
                }
            }
        }
        catch (InterruptedException e) {
            LogUtil.CLog.e(e);
            this.mErrors.add(e);
        }
        finally {
            executor.shutdownNow();
        }
        return results;
    }

    public boolean hasErrors() {
        return !this.mErrors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.mErrors;
    }
}

