/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.hostmetric;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.VersionParser;
import com.android.tradefed.util.hostmetric.IHostHealthAgent;
import com.android.tradefed.util.hostmetric.IHostMonitor;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractHostMonitor
extends Thread
implements IHostMonitor {
    @Option(name="dispatch-interval", description="the time interval between dispatches in ms", isTimeVal=true)
    private long mDispatchInterval = 15000L;
    @Option(name="agent-name", description="the name of the agent object to be used")
    private String mAgentName = "host_metric_agent";
    @Option(name="event-tag", description="Event Tag that will be accepted by the Monitor.")
    private IHostMonitor.HostMetricType mTag = IHostMonitor.HostMetricType.NONE;
    protected Queue<IHostMonitor.HostDataPoint> mHostEvents = new LinkedBlockingQueue<IHostMonitor.HostDataPoint>();
    protected Map<String, String> mHostData = new HashMap<String, String>();
    private boolean mIsCanceled = false;

    public AbstractHostMonitor() {
        super("AbstractHostMonitor");
        this.setDaemon(true);
    }

    public abstract void dispatch();

    public IHostMonitor.HostMetricType getTag() {
        return this.mTag;
    }

    @Override
    public void run() {
        try {
            this.mHostData.put("hostname", InetAddress.getLocalHost().getHostName());
            this.mHostData.put("tradefed_version", VersionParser.fetchVersion());
            while (!this.mIsCanceled) {
                this.dispatch();
                this.getRunUtil().sleep(this.mDispatchInterval);
            }
        }
        catch (Exception e) {
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public synchronized void addHostEvent(IHostMonitor.HostMetricType tag, IHostMonitor.HostDataPoint event) {
        if (this.getTag().equals((Object)tag)) {
            this.mHostEvents.add(event);
        }
    }

    @Override
    public void terminate() {
        this.mIsCanceled = true;
    }

    IHostHealthAgent getMetricAgent() {
        IHostHealthAgent agent = (IHostHealthAgent)GlobalConfiguration.getInstance().getConfigurationObject(this.mAgentName);
        return agent;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    int getQueueSize() {
        return this.mHostEvents.size();
    }
}

