/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.hostmetric;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.Email;
import com.android.tradefed.util.IEmail;
import com.android.tradefed.util.hostmetric.HostMetric;
import com.android.tradefed.util.hostmetric.IHostHealthAgent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="host_metric_agent_email", global_namespace=false)
public class EmailHostHealthAgent
implements IHostHealthAgent {
    @Option(name="sender", description="The envelope-sender address to use for the messages.", importance=Option.Importance.IF_UNSET)
    private String mSender = null;
    @Option(name="destination", description="The destination email addresses. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mDestinations = new HashSet<String>();
    private List<HostMetric> mMetrics = new LinkedList<HostMetric>();

    @Override
    public void emitValue(String name, long value, Map<String, String> data) {
        this.mMetrics.add(new HostMetric(name, System.currentTimeMillis(), value, data));
    }

    @Override
    public void flush() {
        if (this.mMetrics.isEmpty()) {
            LogUtil.CLog.i("No metric to send, skipping HostMetricAgentEmail.");
            return;
        }
        if (this.mDestinations.isEmpty()) {
            LogUtil.CLog.w("No email sent because no destination addresses were set.");
            return;
        }
        if (this.mSender == null) {
            LogUtil.CLog.w("No email sent because no sender addresse was set.");
            return;
        }
        Email mMailer = new Email();
        IEmail.Message msg = new IEmail.Message();
        msg.setSender(this.mSender);
        msg.setSubject(this.generateEmailSubject());
        msg.setBody(this.generateEmailBody());
        msg.setHtml(false);
        Iterator<String> toAddress = this.mDestinations.iterator();
        while (toAddress.hasNext()) {
            msg.addTo(toAddress.next());
        }
        try {
            LogUtil.CLog.d(msg.getSubject());
            LogUtil.CLog.d(msg.getBody());
            mMailer.send(msg);
        }
        catch (IllegalArgumentException e) {
            LogUtil.CLog.e("Failed to send email");
            LogUtil.CLog.e(e);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to send email");
            LogUtil.CLog.e(e);
        }
    }

    private String generateEmailSubject() {
        StringBuilder subj = new StringBuilder("Tradefed host: ");
        try {
            subj.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            subj.append("UNKNOWN");
        }
        subj.append(" - Health Report");
        return subj.toString();
    }

    private String generateEmailBody() {
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append("Reporting Event from Host Health Monitor:\n\n");
        while (!this.mMetrics.isEmpty()) {
            HostMetric tmp = this.mMetrics.remove(0);
            try {
                JSONObject metric = tmp.toJson();
                Iterator i = metric.keys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    bodyBuilder.append(key).append(": ").append(metric.get(key)).append("\n");
                }
            }
            catch (JSONException e) {
                LogUtil.CLog.e(e);
            }
        }
        return bodyBuilder.toString();
    }
}

