/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.hostmetric;

import com.android.ddmlib.Log;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.util.hostmetric.AbstractHostMonitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class HeapHostMonitor
extends AbstractHostMonitor {
    protected static final String HEAP_KEY = "heap_memory_Mbytes";

    public HeapHostMonitor() {
        this.setName("HeapHostMonitor");
    }

    @Override
    public void dispatch() {
        this.mHostEvents.clear();
        Runtime rt = Runtime.getRuntime();
        long totalJvmMemory = (rt.totalMemory() - rt.freeMemory()) / 0x100000L;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(HEAP_KEY, Long.toString(totalJvmMemory));
        this.logEvent(args);
    }

    @VisibleForTesting
    void logEvent(Map<String, String> args) {
        LogRegistry.getLogRegistry().logEvent(Log.LogLevel.INFO, ILogRegistry.EventType.HEAP_MEMORY, args);
    }
}

