/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.image;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DeviceImageTracker {
    private static DeviceImageTracker sDefaultInstance;
    private final LoadingCache<String, FileCacheTracker> mImageCache;
    private final File mCacheDir;

    public static DeviceImageTracker getDefaultCache() {
        if (sDefaultInstance == null) {
            sDefaultInstance = new DeviceImageTracker();
        }
        return sDefaultInstance;
    }

    protected DeviceImageTracker() {
        try {
            this.mCacheDir = FileUtil.createTempDir("image_file_cache_dir");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RemovalListener<String, FileCacheTracker> listener = new RemovalListener<String, FileCacheTracker>(){

            @Override
            public void onRemoval(RemovalNotification<String, FileCacheTracker> n) {
                if (n.wasEvicted()) {
                    FileUtil.deleteFile(((FileCacheTracker)n.getValue()).zippedDeviceImage);
                    FileUtil.deleteFile(((FileCacheTracker)n.getValue()).zippedBootloaderImage);
                    FileUtil.deleteFile(((FileCacheTracker)n.getValue()).zippedBasebandImage);
                }
            }
        };
        this.mImageCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterAccess(1L, TimeUnit.DAYS).removalListener(listener).build(new CacheLoader<String, FileCacheTracker>(){

            @Override
            public FileCacheTracker load(String key) throws IOException {
                return null;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DeviceImageTracker.this.cleanUp();
            }
        });
    }

    public void trackUpdatedDeviceImage(String serial, File deviceImage, File bootloader, File baseband, String buildId, String branch, String flavor) {
        File copyInCacheDeviceImage = new File(this.mCacheDir, serial + "_device_image");
        FileUtil.deleteFile(copyInCacheDeviceImage);
        File copyInCacheBootloader = new File(this.mCacheDir, serial + "_bootloader");
        FileUtil.deleteFile(copyInCacheBootloader);
        File copyInCacheBaseband = new File(this.mCacheDir, serial + "_baseband");
        FileUtil.deleteFile(copyInCacheBaseband);
        try {
            FileUtil.hardlinkFile(deviceImage, copyInCacheDeviceImage);
            FileUtil.hardlinkFile(bootloader, copyInCacheBootloader);
            FileUtil.hardlinkFile(baseband, copyInCacheBaseband);
            this.mImageCache.put(serial, new FileCacheTracker(copyInCacheDeviceImage, copyInCacheBootloader, copyInCacheBaseband, buildId, branch, flavor));
        }
        catch (IOException e) {
            this.invalidateTracking(serial);
            LogUtil.CLog.e(e);
        }
    }

    public void invalidateTracking(String serial) {
        this.mImageCache.invalidate(serial);
    }

    protected void cleanUp() {
        this.mImageCache.invalidateAll();
        FileUtil.recursiveDelete(this.mCacheDir);
    }

    public FileCacheTracker getBaselineDeviceImage(String serial) {
        return (FileCacheTracker)this.mImageCache.getIfPresent(serial);
    }

    public class FileCacheTracker {
        public File zippedDeviceImage;
        public File zippedBootloaderImage;
        public File zippedBasebandImage;
        public String buildId;
        public String branch;
        public String flavor;

        FileCacheTracker(File zippedDeviceImage, File zippedBootloaderImage, File zippedBasebandImage, String buildId, String branch, String flavor) {
            this.zippedDeviceImage = zippedDeviceImage;
            this.zippedBootloaderImage = zippedBootloaderImage;
            this.zippedBasebandImage = zippedBasebandImage;
            this.buildId = buildId;
            this.branch = branch;
            this.flavor = flavor;
        }
    }
}

