/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.keystore;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.android.tradefed.util.keystore.KeyStoreException;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONFileKeyStoreClient
implements IKeyStoreClient {
    private File mJsonFile = null;
    protected JSONObject mJsonKeyStore = null;

    public JSONFileKeyStoreClient() {
    }

    public JSONFileKeyStoreClient(File jsonFile) throws KeyStoreException {
        this.mJsonFile = jsonFile;
        if (this.mJsonFile == null) {
            throw new KeyStoreException("JSON key store file not set.");
        }
        if (!this.mJsonFile.canRead()) {
            throw new KeyStoreException(String.format("Unable to read the JSON key store file %s", this.mJsonFile.toString()));
        }
        try {
            String data = FileUtil.readStringFromFile(this.mJsonFile);
            this.mJsonKeyStore = new JSONObject(data);
        }
        catch (IOException e) {
            throw new KeyStoreException(String.format("Failed to read JSON key file %s: %s", this.mJsonFile.toString(), e));
        }
        catch (JSONException e) {
            throw new KeyStoreException(String.format("Failed to parse JSON data from file %s with exception: %s", this.mJsonFile.toString(), e));
        }
    }

    @Override
    public boolean isAvailable() {
        return this.mJsonKeyStore != null;
    }

    @Override
    public boolean containsKey(String key) {
        LogUtil.CLog.i("fetching key for %s", key);
        if (this.mJsonKeyStore == null) {
            LogUtil.CLog.w("Key Store is null");
            return false;
        }
        return this.mJsonKeyStore.has(key);
    }

    @Override
    public String fetchKey(String key) {
        if (key == null) {
            LogUtil.CLog.w("null key passed");
            return null;
        }
        if (this.mJsonKeyStore == null) {
            LogUtil.CLog.w("null keystore");
            return null;
        }
        try {
            return this.mJsonKeyStore.getString(key);
        }
        catch (JSONException e) {
            LogUtil.CLog.e("failed to fetch key from json key store");
            LogUtil.CLog.e(e);
            return null;
        }
    }

    public void setKeyStore(JSONObject keyStore) {
        this.mJsonKeyStore = keyStore;
    }

    protected void setKey(String key, String value) throws JSONException {
        if (key == null) {
            LogUtil.CLog.w("null key passed");
            return;
        }
        if (this.mJsonKeyStore == null) {
            LogUtil.CLog.w("null keystore");
            return;
        }
        this.mJsonKeyStore.put(key, value);
    }
}

