/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.keystore;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.android.tradefed.util.keystore.IKeyStoreFactory;
import com.android.tradefed.util.keystore.JSONFileKeyStoreClient;
import com.android.tradefed.util.keystore.KeyStoreException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="json-keystore")
public class JSONFileKeyStoreFactory
implements IKeyStoreFactory {
    @Option(name="json-key-store-file", description="The JSON file from where to read the key store", importance=Option.Importance.IF_UNSET)
    private File mJsonFile = null;
    @Option(name="host-based-key-store-file", description="The JSON file from where to read the host-based key store", importance=Option.Importance.IF_UNSET)
    private List<File> mHostBasedJsonFiles = new ArrayList<File>();
    private static final Object mLock = new Object();
    private JSONFileKeyStoreClient mCachedClient = null;
    private long mLastLoadedTime = 0L;
    private String mHostName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IKeyStoreClient createKeyStoreClient() throws KeyStoreException {
        Object object = mLock;
        synchronized (object) {
            this.mHostName = this.getHostName();
            List<String> invalidFiles = this.findInvalidJsonKeyStoreFiles();
            if (this.mCachedClient == null) {
                if (!invalidFiles.isEmpty()) {
                    throw new KeyStoreException(String.format("These keystore files are missing: %s", String.join((CharSequence)"\n", invalidFiles)));
                }
                this.createKeyStoreInternal();
                LogUtil.CLog.d("Keystore initialized with %s and %d host-based keystore files.", this.mJsonFile.getAbsolutePath(), this.mHostBasedJsonFiles.size());
            }
            if (!invalidFiles.isEmpty()) {
                LogUtil.CLog.w(String.format("These keystore files are missing: %s", String.join((CharSequence)"\n", invalidFiles)));
            } else {
                List<String> changedFiles = this.findChangedJsonKeyStoreFiles();
                if (!changedFiles.isEmpty()) {
                    this.createKeyStoreInternal();
                    LogUtil.CLog.d("Reloading the keystore as these keystore files have changed: %s", String.join((CharSequence)"\n", changedFiles));
                }
            }
            return this.mCachedClient;
        }
    }

    private String getHostName() throws KeyStoreException {
        if (this.mHostName == null) {
            try {
                this.mHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new KeyStoreException(String.format("Failed to get hostname", new Object[0]), e);
            }
        }
        return this.mHostName;
    }

    private List<String> findInvalidJsonKeyStoreFiles() {
        ArrayList<String> invalidFiles = new ArrayList<String>();
        if (!this.mJsonFile.exists() || !this.mJsonFile.canRead()) {
            invalidFiles.add(this.mJsonFile.getAbsolutePath());
        }
        for (File file2 : this.mHostBasedJsonFiles) {
            if (file2.exists() && file2.canRead()) continue;
            invalidFiles.add(file2.getAbsolutePath());
        }
        return invalidFiles;
    }

    private List<String> findChangedJsonKeyStoreFiles() {
        ArrayList<String> changedFiles = new ArrayList<String>();
        if (this.mLastLoadedTime < this.mJsonFile.lastModified()) {
            changedFiles.add(this.mJsonFile.getAbsolutePath());
        }
        for (File file2 : this.mHostBasedJsonFiles) {
            if (this.mLastLoadedTime >= file2.lastModified()) continue;
            changedFiles.add(file2.getAbsolutePath());
        }
        return changedFiles;
    }

    private void createKeyStoreInternal() throws KeyStoreException {
        this.mLastLoadedTime = System.currentTimeMillis();
        this.mCachedClient = new JSONFileKeyStoreClient(this.mJsonFile);
        for (File file2 : this.mHostBasedJsonFiles) {
            this.overrideClientWithHostKeyStoreFromFile(file2);
        }
    }

    private void overrideClientWithHostKeyStoreFromFile(File file2) throws KeyStoreException {
        JSONObject hostKeyStore = this.getHostKeyStoreFromFile(file2);
        if (hostKeyStore == null) {
            LogUtil.CLog.d("Host-based keystore for %s not found in Keystore file %s", this.mHostName, this.mJsonFile.getAbsolutePath());
            return;
        }
        Iterator keys = hostKeyStore.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                this.mCachedClient.setKey(key, hostKeyStore.getString(key));
                LogUtil.CLog.d("Hostname: %s, %s gets value from file:%s", this.mHostName, key, this.mJsonFile.getAbsolutePath());
            }
            catch (JSONException e) {
                throw new KeyStoreException(String.format("Failed to update keystore with host-based keystore from file %s", file2.toString()), e);
            }
        }
    }

    private JSONObject getHostKeyStoreFromFile(File file2) throws KeyStoreException {
        JSONObject hostKeyStore = null;
        JSONObject jsonKeyStore = this.loadKeyStoreFromFile(file2);
        int matchingPatternCount = 0;
        Iterator patternStrings = jsonKeyStore.keys();
        while (patternStrings.hasNext()) {
            String patternString = (String)patternStrings.next();
            Pattern pattern = Pattern.compile(patternString);
            if (!pattern.matcher(this.mHostName).matches()) continue;
            LogUtil.CLog.d("Hostname %s matches pattern string %s in file %s.", this.mHostName, patternString, file2.getAbsolutePath());
            if (++matchingPatternCount > 1) {
                throw new KeyStoreException(String.format("Hostname %s matches multiple pattern strings in file %s.", this.mHostName, file2.toString()));
            }
            try {
                hostKeyStore = jsonKeyStore.getJSONObject(patternString);
            }
            catch (JSONException e) {
                throw new KeyStoreException(String.format("Failed to parse JSON data from file %s", file2.toString()), e);
            }
        }
        return hostKeyStore;
    }

    private JSONObject loadKeyStoreFromFile(File jsonFile) throws KeyStoreException {
        JSONObject keyStore = null;
        try {
            String data = FileUtil.readStringFromFile(jsonFile);
            keyStore = new JSONObject(data);
        }
        catch (IOException e) {
            throw new KeyStoreException(String.format("Failed to read JSON key file %s: %s", jsonFile.toString(), e));
        }
        catch (JSONException e) {
            throw new KeyStoreException(String.format("Failed to parse JSON data from file %s", jsonFile.toString()), e);
        }
        return keyStore;
    }

    @VisibleForTesting
    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }
}

